/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.minecolonies.api.blocks.AbstractBlockMinecolonies;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.FarmlandWaterManager;
import net.neoforged.neoforge.common.SpecialPlantable;
import org.jetbrains.annotations.NotNull;

public class MinecoloniesFarmland
extends AbstractBlockMinecolonies<MinecoloniesFarmland>
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final String FARMLAND = "farmland";
    public static final String FLOODED_FARMLAND = "floodedfarmland";
    public static final IntegerProperty MOISTURE = BlockStateProperties.MOISTURE;
    protected final VoxelShape shape;
    private final ResourceLocation blockId;
    private final boolean waterLogged;

    public MinecoloniesFarmland(@NotNull String blockName, boolean waterLogged, double height) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).randomTicks().strength(0.6f).sound(SoundType.GRAVEL).isViewBlocking((s, g, p) -> true).isSuffocating((s, g, p) -> true));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
        this.blockId = new ResourceLocation("minecolonies", blockName);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterLogged)));
        this.shape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
        this.waterLogged = waterLogged;
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState newState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (direction == Direction.UP && !state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && this.waterLogged) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, newState, level, pos, neighborPos);
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        if (level == null) {
            return true;
        }
        BlockState aboveState = level.getBlockState(pos.above());
        return !aboveState.isSolid();
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return !this.defaultBlockState().canSurvive((LevelReader)ctx.getLevel(), ctx.getClickedPos()) ? Blocks.DIRT.defaultBlockState() : super.getStateForPlacement(ctx);
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return this.shape;
    }

    public void randomTick(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rng) {
        Block block;
        if (!state.canSurvive((LevelReader)level, pos)) {
            MinecoloniesFarmland.turnToDirt(null, state, (Level)level, pos);
            return;
        }
        int i = (Integer)state.getValue((Property)MOISTURE);
        if (!level.isRainingAt(pos.above()) && !MinecoloniesFarmland.isNearWater((LevelReader)level, pos)) {
            if (i > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!MinecoloniesFarmland.shouldMaintainFarmland((BlockGetter)level, pos)) {
                MinecoloniesFarmland.turnToDirt(null, state, (Level)level, pos);
            }
        } else if (i < 7) {
            level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
        BlockState aboveState = level.getBlockState(pos.above());
        int growthChance = 4;
        if (level.isRaining()) {
            growthChance = 12;
        }
        if ((block = aboveState.getBlock()) instanceof MinecoloniesCropBlock) {
            MinecoloniesCropBlock cropBlock = (MinecoloniesCropBlock)block;
            if (rng.nextInt(100) <= growthChance) {
                cropBlock.attemptGrow(aboveState, level, pos.above());
                new VanillaParticleMessage((float)pos.getX() + 0.5f, (float)pos.getY() - 0.5f, (float)pos.getZ() + 0.5f, ParticleTypes.HAPPY_VILLAGER).sendToTargetPoint(level, null, pos.getX(), pos.getY(), pos.getZ(), 16.0);
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rng) {
        if (level.isRaining() && rng.nextInt(100) < 25 && level.getBlockState(pos.above()).getBlock() instanceof MinecoloniesCropBlock) {
            ParticleUtils.spawnParticleInBlock((LevelAccessor)level, (BlockPos)pos, (int)1, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
        }
        super.animateTick(state, level, pos, rng);
    }

    public void fallOn(Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, float light) {
        if (!level.isClientSide && CommonHooks.onFarmlandTrample((Level)level, (BlockPos)pos, (BlockState)Blocks.DIRT.defaultBlockState(), (float)light, (Entity)entity)) {
            MinecoloniesFarmland.turnToDirt(entity, state, level, pos);
        }
        super.fallOn(level, state, pos, entity, light);
    }

    public static void turnToDirt(@Nullable Entity p_270981_, BlockState p_270402_, Level p_270568_, BlockPos p_270551_) {
        BlockState blockstate = MinecoloniesFarmland.pushEntitiesUp((BlockState)p_270402_, (BlockState)Blocks.DIRT.defaultBlockState(), (LevelAccessor)p_270568_, (BlockPos)p_270551_);
        p_270568_.setBlockAndUpdate(p_270551_, blockstate);
        p_270568_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_270551_, GameEvent.Context.of((Entity)p_270981_, (BlockState)blockstate));
    }

    private static boolean shouldMaintainFarmland(BlockGetter p_279219_, BlockPos p_279209_) {
        BlockState plant = p_279219_.getBlockState(p_279209_.above());
        BlockState state = p_279219_.getBlockState(p_279209_);
        return plant.getBlock() instanceof SpecialPlantable && state.canSustainPlant(p_279219_, p_279209_, Direction.UP, plant.getBlock().defaultBlockState()).isTrue();
    }

    private static boolean isNearWater(LevelReader level, BlockPos thisPos) {
        BlockState state = level.getBlockState(thisPos);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int x = thisPos.getX() - 4; x <= thisPos.getX() + 4; ++x) {
            for (int z = thisPos.getZ() - 4; z <= thisPos.getZ() + 4; ++z) {
                for (int y = thisPos.getY() - 1; y <= thisPos.getY(); ++y) {
                    blockPos.set(x, y, z);
                    if (!state.canBeHydrated((BlockGetter)level, thisPos, level.getFluidState((BlockPos)blockPos), (BlockPos)blockPos)) continue;
                    return true;
                }
            }
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)thisPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{MOISTURE, WATERLOGGED});
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.blockId;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false && this.waterLogged ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

