/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public final class CraftingUtils {
    private CraftingUtils() {
        throw new IllegalStateException("Tried to initialize: CraftingUtils but this is a Utility class.");
    }

    public static int calculateMaxCraftingCount(@NotNull ItemStack outputStack, @NotNull IRecipeStorage storage) {
        int craftingCount = (int)Math.ceil((double)Math.max(ItemStackUtils.getSize(outputStack), ItemStackUtils.getSize(storage.getPrimaryOutput())) / (double)ItemStackUtils.getSize(storage.getPrimaryOutput()));
        for (ItemStorage ingredientStorage : storage.getCleanedInput()) {
            ItemStack ingredient = ingredientStorage.getItemStack();
            int ingredientInputCount = ItemStackUtils.getSize(ingredient) * craftingCount;
            if (ingredientInputCount <= ingredient.getMaxStackSize()) continue;
            craftingCount = Math.max(ingredient.getMaxStackSize(), ItemStackUtils.getSize(storage.getPrimaryOutput())) / ItemStackUtils.getSize(storage.getPrimaryOutput());
        }
        return craftingCount;
    }

    public static int calculateMaxCraftingCount(int count, @NotNull IRecipeStorage storage) {
        return (int)Math.ceil((double)Math.max(count, ItemStackUtils.getSize(storage.getPrimaryOutput())) / (double)ItemStackUtils.getSize(storage.getPrimaryOutput()));
    }

    public static OptionalPredicate<ItemStack> getProductValidatorBasedOnTags(@NotNull String crafterJobName) {
        return stack -> {
            TagKey<Item> excludedProducts = ModTags.crafterProductExclusions.get(crafterJobName);
            if (excludedProducts != null && stack.is(excludedProducts)) {
                return Optional.of(false);
            }
            TagKey<Item> allowedProducts = ModTags.crafterProduct.get(crafterJobName);
            if (allowedProducts != null && stack.is(allowedProducts)) {
                return Optional.of(true);
            }
            return Optional.empty();
        };
    }

    public static OptionalPredicate<ItemStack> getIngredientValidatorBasedOnTags(@NotNull String crafterJobName) {
        return CraftingUtils.getIngredientValidatorBasedOnTags(crafterJobName, false);
    }

    public static OptionalPredicate<ItemStack> getIngredientValidatorBasedOnTags(@NotNull String crafterJobName, boolean includeDoRules) {
        return stack -> {
            TagKey<Item> includedDoIngredients;
            if (includeDoRules && (includedDoIngredients = ModTags.crafterDoIngredient.get(crafterJobName)) != null && stack.is(includedDoIngredients)) {
                return Optional.of(true);
            }
            TagKey<Item> excludedIngredients = ModTags.crafterIngredientExclusions.get(crafterJobName);
            if (excludedIngredients != null && stack.is(excludedIngredients)) {
                return Optional.of(false);
            }
            TagKey<Item> allowedIngredients = ModTags.crafterIngredient.get(crafterJobName);
            if (allowedIngredients != null && stack.is(allowedIngredients)) {
                return Optional.of(true);
            }
            return Optional.empty();
        };
    }

    public static Optional<Boolean> isRecipeCompatibleBasedOnTags(@NotNull IGenericRecipe recipe, @NotNull String crafterJobName) {
        return OptionalPredicate.combine(recipe.matchesOutput(CraftingUtils.getProductValidatorBasedOnTags(crafterJobName)), () -> recipe.matchesInput(CraftingUtils.getIngredientValidatorBasedOnTags(crafterJobName)));
    }

    public static void forEachCreativeTabItems(@NotNull CreativeModeTab.ItemDisplayParameters displayParams, @NotNull BiConsumer<CreativeModeTab, Collection<ItemStack>> consumer) {
        HolderLookup.RegistryLookup registry = (HolderLookup.RegistryLookup)displayParams.holders().lookup(Registries.CREATIVE_MODE_TAB).get();
        Map<CreativeModeTab, ResourceKey> tabKeys = registry.listElements().distinct().collect(Collectors.toMap(Holder::value, Holder.Reference::key));
        for (CreativeModeTab tab : CreativeModeTabs.allTabs()) {
            HashSet stacks;
            if (tab.getType() != CreativeModeTab.Type.CATEGORY) continue;
            if (tab.getDisplayItems().isEmpty()) {
                stacks = new HashSet();
                try {
                    EventHooks.onCreativeModeTabBuildContents((CreativeModeTab)tab, (ResourceKey)tabKeys.get(tab), (CreativeModeTab.DisplayItemsGenerator)tab.displayItemsGenerator, (CreativeModeTab.ItemDisplayParameters)displayParams, (stack, vis) -> stacks.add(stack));
                }
                catch (Throwable ex) {
                    Log.getLogger().warn("Error populating items for " + tab.getDisplayName().getString(), ex);
                }
            } else {
                stacks = tab.getDisplayItems();
            }
            consumer.accept(tab, stacks);
        }
    }
}

