/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.quests;

import com.google.gson.JsonObject;
import com.minecolonies.api.quests.IFinalQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestPositiveDialogueAnswer;
import net.minecraft.world.entity.player.Player;

public interface IQuestDialogueAnswer {

    public static class QuestCancellationDialogueAnswer
    implements IFinalQuestDialogueAnswer {
        @Override
        public void applyToQuest(Player player, IQuestInstance quest) {
            quest.onDeletion();
        }
    }

    public static class NextObjectiveDialogueAnswer
    implements IQuestPositiveDialogueAnswer {
        private final int nextObjective;

        public NextObjectiveDialogueAnswer(int nextObjective) {
            this.nextObjective = nextObjective;
        }

        public NextObjectiveDialogueAnswer(JsonObject jsonObject) {
            this.nextObjective = jsonObject.get("go-to").getAsInt();
        }

        @Override
        public void applyToQuest(Player player, IQuestInstance quest) {
            quest.advanceObjective(player, this.nextObjective);
        }
    }

    public static class CloseUIDialogueAnswer
    implements IFinalQuestDialogueAnswer {
        @Override
        public void applyToQuest(Player player, IQuestInstance quest) {
        }
    }
}

