/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable.crafting;

import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Log;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCrafting
implements IRequestable {
    protected static final String NBT_STACK = "Stack";
    protected static final String NBT_COUNT = "Count";
    protected static final String NBT_MIN_COUNT = "MinCount";
    protected static final String NBT_TOKEN = "Token";
    @NotNull
    private final ItemStack theStack;
    private final int count;
    private final int minCount;
    private final IToken<?> recipeToken;

    public AbstractCrafting(@NotNull ItemStack stack, int count, int minCount, IToken<?> recipeToken) {
        this.theStack = stack.copy();
        this.count = count;
        this.minCount = minCount;
        this.recipeToken = recipeToken;
        if (stack.isEmpty()) {
            Log.getLogger().error("Created Empty Stack", (Throwable)new Exception());
        } else {
            this.theStack.setCount(Math.min(this.theStack.getCount(), this.theStack.getMaxStackSize()));
        }
    }

    @NotNull
    public ItemStack getStack() {
        return this.theStack;
    }

    public int getCount() {
        return this.count;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public IToken<?> getRecipeID() {
        return this.recipeToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractCrafting)) {
            return false;
        }
        AbstractCrafting that = (AbstractCrafting)o;
        return this.getCount() == that.getCount() && this.getMinCount() == that.getMinCount() && this.theStack.equals(that.theStack);
    }

    public int hashCode() {
        return Objects.hash(this.theStack, this.getCount(), this.getMinCount());
    }
}

