/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.managers.interfaces;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IMysticalSite;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRegisteredStructureManager {
    public void read(@NotNull HolderLookup.Provider var1, @NotNull CompoundTag var2);

    public void write(@NotNull HolderLookup.Provider var1, @NotNull CompoundTag var2);

    public void clearDirty();

    public void sendPackets(Set<ServerPlayer> var1, Set<ServerPlayer> var2);

    public void onColonyTick(IColony var1);

    public void cleanUpBuildings(IColony var1);

    public IBuilding getBuilding(BlockPos var1);

    public List<BlockPos> getLeisureSites();

    @Nullable
    public IBuilding getFirstBuildingMatching(Predicate<IBuilding> var1);

    public void addLeisureSite(BlockPos var1);

    public void removeLeisureSite(BlockPos var1);

    @Nullable
    public IWareHouse getClosestWarehouseInColony(BlockPos var1);

    @NotNull
    public Map<BlockPos, IBuilding> getBuildings();

    public ITownHall getTownHall();

    public int getMysticalSiteMaxBuildingLevel();

    public boolean hasWarehouse();

    public boolean hasMysticalSite();

    public boolean hasTownHall();

    @Nullable
    public <B extends IBuilding> B getBuilding(BlockPos var1, @NotNull Class<B> var2);

    public void removeBuilding(@NotNull IBuilding var1, Set<ServerPlayer> var2);

    public void markBuildingsDirty();

    public void markBuildingExtensionsDirty();

    @Nullable
    public IBuilding addNewBuilding(@NotNull AbstractTileEntityColonyBuilding var1, Level var2);

    public BlockPos getBestBuilding(AbstractEntityCitizen var1, Class<? extends IBuilding> var2);

    public <T extends IBuilding> BlockPos getBestBuilding(AbstractEntityCitizen var1, Class<T> var2, @NotNull Predicate<T> var3);

    public BlockPos getBestBuilding(BlockPos var1, Class<? extends IBuilding> var2);

    public <T extends IBuilding> BlockPos getBestBuilding(BlockPos var1, Class<T> var2, @NotNull Predicate<T> var3);

    public BlockPos getRandomBuilding(Predicate<IBuilding> var1);

    public boolean hasGuardBuildingNear(IBuilding var1);

    public void guardBuildingChangedAt(IBuilding var1, int var2);

    public void setTownHall(@Nullable ITownHall var1);

    public void removeWareHouse(IWareHouse var1);

    public List<IWareHouse> getWareHouses();

    public void removeMysticalSite(IMysticalSite var1);

    public List<IMysticalSite> getMysticalSites();

    public boolean canPlaceAt(Block var1, BlockPos var2, Player var3);

    public boolean keepChunkColonyLoaded(LevelChunk var1);

    public IBuilding getHouseWithSpareBed();

    public void onBuildingUpgradeComplete(@Nullable IBuilding var1, int var2);

    public BlockPos getRandomLeisureSite();

    @NotNull
    public List<IBuildingExtension> getBuildingExtensions(Predicate<IBuildingExtension> var1);

    public Optional<IBuildingExtension> getMatchingBuildingExtension(Predicate<IBuildingExtension> var1);

    public boolean addBuildingExtension(IBuildingExtension var1);

    public void removeBuildingExtension(Predicate<IBuildingExtension> var1);

    @Nullable
    public IBuildingExtension getMatchingBuildingExtension(IBuildingExtension.ExtensionId var1);
}

