/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks.types;

import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum RackType implements StringRepresentable
{
    EMPTY("blockrackemptysingle", "emptysingle", false),
    FULL("blockrackfullsingle", "fullsingle", false),
    EMPTY_DOUBLE("blockrackempty", "empty", true),
    FULL_DOUBLE("blockrackfull", "full", true),
    NO_RENDER("blockrackair", "dontrender", true);

    private final String name;
    private final String unlocalizedName;
    private boolean doubleVariant = false;

    private RackType(String name, String unlocalizedName, boolean doubleVariant) {
        this.name = name;
        this.unlocalizedName = unlocalizedName;
        this.doubleVariant = doubleVariant;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return this.unlocalizedName;
    }

    public boolean isDoubleVariant() {
        return this.doubleVariant;
    }

    public RackType getInvBasedVariant(boolean empty) {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                return empty ? EMPTY : FULL;
            }
            case 2: 
            case 3: {
                return empty ? EMPTY_DOUBLE : FULL_DOUBLE;
            }
        }
        return NO_RENDER;
    }

    @NotNull
    public String getSerializedName() {
        return this.getName();
    }
}

