/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class PlaceStructureTrigger
extends SimpleCriterionTrigger<PlaceStructureTriggerInstance> {
    public void trigger(ServerPlayer player, String structureName) {
        this.trigger(player, trigger -> trigger.test(structureName));
    }

    public Codec<PlaceStructureTriggerInstance> codec() {
        return PlaceStructureTriggerInstance.CODEC;
    }

    public record PlaceStructureTriggerInstance(Optional<ContextAwarePredicate> player, Optional<String> structureName) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<PlaceStructureTriggerInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(PlaceStructureTriggerInstance::player), (App)Codec.STRING.optionalFieldOf("hut_name").forGetter(PlaceStructureTriggerInstance::structureName)).apply((Applicative)builder, PlaceStructureTriggerInstance::new));

        public static Criterion<PlaceStructureTriggerInstance> placeStructure() {
            return PlaceStructureTriggerInstance.placeStructure(null);
        }

        public static Criterion<PlaceStructureTriggerInstance> placeStructure(String hutName) {
            return ((PlaceStructureTrigger)((Object)AdvancementTriggers.PLACE_STRUCTURE.get())).createCriterion((CriterionTriggerInstance)new PlaceStructureTriggerInstance(Optional.empty(), Optional.ofNullable(hutName)));
        }

        public boolean test(String hutName) {
            if (this.structureName.isPresent()) {
                return this.structureName.get().equalsIgnoreCase(hutName);
            }
            return true;
        }
    }
}

