/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;

public class CreateBuildRequestTrigger
extends SimpleCriterionTrigger<CreateBuildRequestTriggerInstance> {
    public void trigger(ServerPlayer player, String structureName, int level) {
        this.trigger(player, trigger -> trigger.test(structureName, level));
    }

    public Codec<CreateBuildRequestTriggerInstance> codec() {
        return CreateBuildRequestTriggerInstance.CODEC;
    }

    public record CreateBuildRequestTriggerInstance(Optional<ContextAwarePredicate> player, Optional<String> hutName, int level) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final int DEFAULT_LEVEL = -1;
        public static final Codec<CreateBuildRequestTriggerInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(CreateBuildRequestTriggerInstance::player), (App)Codec.STRING.optionalFieldOf("hut_name").forGetter(CreateBuildRequestTriggerInstance::hutName), (App)ExtraCodecs.intRange((int)0, (int)5).optionalFieldOf("level", (Object)-1).forGetter(CreateBuildRequestTriggerInstance::level)).apply((Applicative)builder, CreateBuildRequestTriggerInstance::new));

        public static Criterion<CreateBuildRequestTriggerInstance> createBuildRequest() {
            return CreateBuildRequestTriggerInstance.createBuildRequest(null);
        }

        public static Criterion<CreateBuildRequestTriggerInstance> createBuildRequest(String hutName) {
            return CreateBuildRequestTriggerInstance.createBuildRequest(hutName, -1);
        }

        public static Criterion<CreateBuildRequestTriggerInstance> createBuildRequest(String hutName, int level) {
            return ((CreateBuildRequestTrigger)((Object)AdvancementTriggers.CREATE_BUILD_REQUEST.get())).createCriterion((CriterionTriggerInstance)new CreateBuildRequestTriggerInstance(Optional.empty(), Optional.ofNullable(hutName), level));
        }

        public boolean test(String structureName, int level) {
            if (this.hutName.isPresent() && this.level != -1) {
                return this.hutName.get().equalsIgnoreCase(structureName) && this.level <= level;
            }
            if (this.hutName.isPresent()) {
                return this.hutName.get().equalsIgnoreCase(structureName);
            }
            return true;
        }
    }
}

