/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.procedures;

import java.util.Random;
import javax.annotation.Nullable;
import net.mcreator.valarian_conquest.entity.SoldierEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.UseAnim;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="valarian_conquest")
public class ShieldBlockProcedure {
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        ShieldBlockProcedure.execute((Event)event, event.getEntity());
    }

    public static void execute(Entity entity) {
        ShieldBlockProcedure.execute(null, entity);
    }

    private static void execute(@Nullable Event event, Entity entity) {
        LivingEntity livingTarget;
        double distSq;
        if (!(entity instanceof SoldierEntity)) {
            return;
        }
        SoldierEntity soldier = (SoldierEntity)entity;
        CompoundTag data = soldier.getPersistentData();
        if (data.getInt("BlockCooldown") > 0) {
            data.putInt("BlockCooldown", data.getInt("BlockCooldown") - 1);
            return;
        }
        if (data.getInt("BlockingTicks") > 0) {
            data.putInt("BlockingTicks", data.getInt("BlockingTicks") - 1);
            if (data.getInt("BlockingTicks") == 0) {
                soldier.stopUsingItem();
                data.putInt("BlockCooldown", 40 + random.nextInt(40));
            }
            return;
        }
        LivingEntity target = soldier.getTarget();
        if (target instanceof LivingEntity && (distSq = soldier.distanceToSqr((Entity)(livingTarget = target))) <= 36.0 && random.nextFloat() < 0.3f) {
            if (soldier.getOffhandItem().getUseAnimation() == UseAnim.BLOCK) {
                soldier.startUsingItem(InteractionHand.OFF_HAND);
            } else if (soldier.getMainHandItem().getUseAnimation() == UseAnim.BLOCK) {
                soldier.startUsingItem(InteractionHand.MAIN_HAND);
            }
            data.putInt("BlockingTicks", 40);
        }
    }
}

