/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.procedures;

import javax.annotation.Nullable;
import net.mcreator.valarian_conquest.entity.SoldierEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber
public class ShieldBlockNegateDamageProcedure {
    @SubscribeEvent
    public static void onEntityAttacked(LivingIncomingDamageEvent event) {
        if (event == null || event.getEntity() == null) {
            return;
        }
        ShieldBlockNegateDamageProcedure.execute(event, (Entity)event.getEntity(), event.getSource());
    }

    public static void execute(Entity entity, DamageSource damageSource) {
        ShieldBlockNegateDamageProcedure.execute(null, entity, damageSource);
    }

    private static void execute(@Nullable LivingIncomingDamageEvent event, Entity entity, DamageSource damageSource) {
        ItemStack usingStack;
        if (!(entity instanceof SoldierEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (living.isUsingItem() && (usingStack = living.getUseItem()).getItem() instanceof ShieldItem && ShieldBlockNegateDamageProcedure.isBlockableDamage(damageSource) && event != null) {
            event.setCanceled(true);
            Level level = entity.level();
            if (level instanceof Level) {
                Level level2 = level;
                level2.playSound(null, entity.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.PLAYERS, 0.5f, 0.8f + level2.random.nextFloat() * 0.4f);
            }
        }
    }

    private static boolean isBlockableDamage(DamageSource source) {
        return source.is(DamageTypes.MOB_ATTACK) || source.is(DamageTypes.PLAYER_ATTACK) || source.is(DamageTypes.ARROW) || source.is(DamageTypes.TRIDENT) || source.is(DamageTypes.MOB_PROJECTILE) || source.is(DamageTypes.THROWN);
    }
}

