/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.procedures;

import java.util.Comparator;
import java.util.List;
import net.mcreator.valarian_conquest.entity.BallistaEntity;
import net.mcreator.valarian_conquest.entity.BatteringRamEntity;
import net.mcreator.valarian_conquest.entity.CannonEntity;
import net.mcreator.valarian_conquest.entity.CarriageEntity;
import net.mcreator.valarian_conquest.entity.CatapultEntity;
import net.mcreator.valarian_conquest.network.ValarianConquestModVariables;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class NPCMountButtonProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        Vec3 center = new Vec3(x, y, z);
        List<Entity> entitiesFound = world.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(12.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList();
        for (Entity entityIterator : entitiesFound) {
            if (!ValarianConquestModVariables.WorldVariables.get((LevelAccessor)world).uuid.equals(entityIterator.getStringUUID())) continue;
            if (entityIterator.isPassenger()) {
                entityIterator.stopRiding();
                continue;
            }
            List potentialMounts = world.getEntitiesOfClass(Entity.class, AABB.ofSize((Vec3)center, (double)24.0, (double)24.0, (double)24.0), e -> e.getPassengers().isEmpty() && (e instanceof Horse || e instanceof BallistaEntity || e instanceof CannonEntity || e instanceof CarriageEntity || e instanceof BatteringRamEntity || e instanceof CatapultEntity));
            if (potentialMounts.isEmpty()) {
                Player _player;
                if (entity instanceof Player && !(_player = (Player)entity).level().isClientSide()) {
                    _player.displayClientMessage((Component)Component.literal((String)"No Mount Nearby"), true);
                }
                return;
            }
            Entity nearest = potentialMounts.stream().min(Comparator.comparingDouble(e -> e.distanceToSqr(center))).orElse(null);
            if (nearest == null) {
                return;
            }
            if (nearest instanceof Horse) {
                Horse horse = (Horse)nearest;
                horse.setTamed(true);
                ItemStack saddle = new ItemStack((ItemLike)Items.SADDLE);
                IItemHandlerModifiable cap = (IItemHandlerModifiable)horse.getCapability(Capabilities.ItemHandler.ENTITY, null);
                if (cap != null) {
                    cap.setStackInSlot(0, saddle);
                }
            }
            entityIterator.startRiding(nearest, true);
            break;
        }
    }
}

