/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.procedures;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="valarian_conquest")
public class ClaimedCitizenFactionProcedure {
    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        ClaimedCitizenFactionProcedure.execute((Event)event, (LevelAccessor)event.getEntity().level(), event.getEntity());
    }

    public static void execute(LevelAccessor world, Entity entity) {
        ClaimedCitizenFactionProcedure.execute(null, world, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, Entity entity) {
        PlayerTeam team;
        String ownerTeam;
        String entityTeam;
        ServerLevel serverLevel;
        Player owner;
        String ownerUUID;
        if (entity == null || world.isClientSide() || !(entity instanceof LivingEntity)) {
            return;
        }
        TagKey CLAIMED_TAG = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"claimed"));
        if (!entity.getType().is(CLAIMED_TAG)) {
            return;
        }
        if (entity.tickCount % 20 != 0) {
            return;
        }
        if (entity.getPersistentData().getBoolean("claimed_citizen") && !(ownerUUID = entity.getPersistentData().getString("citizen_owner")).isEmpty() && world instanceof ServerLevel && (owner = (serverLevel = (ServerLevel)world).getPlayerByUUID(UUID.fromString(ownerUUID))) != null && !(entityTeam = ClaimedCitizenFactionProcedure.getEntityTeam(entity)).equals(ownerTeam = ClaimedCitizenFactionProcedure.getEntityTeam((Entity)owner)) && (team = serverLevel.getScoreboard().getPlayerTeam(ownerTeam)) != null) {
            serverLevel.getScoreboard().addPlayerToTeam(entity instanceof Player ? ((Player)entity).getGameProfile().getName() : entity.getStringUUID(), team);
        }
    }

    private static String getEntityTeam(Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).level().getScoreboard().getPlayersTeam(entity instanceof Player ? ((Player)entity).getGameProfile().getName() : living.getStringUUID()) != null) {
            return living.level().getScoreboard().getPlayersTeam(entity instanceof Player ? ((Player)entity).getGameProfile().getName() : living.getStringUUID()).getName();
        }
        return "";
    }
}

