/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.network;

import net.mcreator.valarian_conquest.ValarianConquestMod;
import net.mcreator.valarian_conquest.procedures.ClaimCitizenArcherProcedure;
import net.mcreator.valarian_conquest.procedures.ClaimCitizenProcedureProcedure;
import net.mcreator.valarian_conquest.procedures.ClaimCitizenSoldierProcedure;
import net.mcreator.valarian_conquest.procedures.NPCDecreaseHealthProcedure;
import net.mcreator.valarian_conquest.procedures.NPCGuardButtonProcedure;
import net.mcreator.valarian_conquest.procedures.NPCIncreaseHealthProcedure;
import net.mcreator.valarian_conquest.procedures.NPCLongPatrolButtonProcedure;
import net.mcreator.valarian_conquest.procedures.NPCMountButtonProcedure;
import net.mcreator.valarian_conquest.procedures.NPCPatrolButtonProcedure;
import net.mcreator.valarian_conquest.procedures.NPCSaveNameProcedure;
import net.mcreator.valarian_conquest.procedures.NPCSetFollowerProcedure;
import net.mcreator.valarian_conquest.procedures.NPCSheatheWeaponProcedure;
import net.mcreator.valarian_conquest.procedures.NPCStandGuardButtonProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record NPCInventoryGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<NPCInventoryGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"valarian_conquest", (String)"npc_inventory_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, NPCInventoryGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new NPCInventoryGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<NPCInventoryGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(NPCInventoryGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> NPCInventoryGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            NPCIncreaseHealthProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            NPCDecreaseHealthProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            ClaimCitizenProcedureProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            NPCSetFollowerProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            ClaimCitizenArcherProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            ClaimCitizenSoldierProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            NPCStandGuardButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            NPCGuardButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            NPCPatrolButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            NPCSheatheWeaponProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 10) {
            NPCMountButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            NPCLongPatrolButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 12) {
            NPCSaveNameProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ValarianConquestMod.addNetworkMessage(TYPE, STREAM_CODEC, NPCInventoryGUIButtonMessage::handleData);
    }
}

