/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.network;

import net.mcreator.valarian_conquest.ValarianConquestMod;
import net.mcreator.valarian_conquest.procedures.ButtonFollowCommandsProcedure;
import net.mcreator.valarian_conquest.procedures.ButtonMountCommandsProcedure;
import net.mcreator.valarian_conquest.procedures.ButtonPatrolCommandsProcedure;
import net.mcreator.valarian_conquest.procedures.ButtonStanceCommandsProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record CommandWandGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CommandWandGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"valarian_conquest", (String)"command_wand_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CommandWandGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new CommandWandGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<CommandWandGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(CommandWandGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> CommandWandGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ButtonStanceCommandsProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ButtonPatrolCommandsProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ButtonMountCommandsProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ButtonFollowCommandsProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ValarianConquestMod.addNetworkMessage(TYPE, STREAM_CODEC, CommandWandGUIButtonMessage::handleData);
    }
}

