/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.item;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LongbowItem
extends BowItem {
    public LongbowItem() {
        super(new Item.Properties().durability(384).rarity(Rarity.UNCOMMON));
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        boolean infinite;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack ammoStack = player.getProjectile(stack);
        if (ammoStack.isEmpty() && !player.getAbilities().instabuild) {
            return;
        }
        int charge = this.getUseDuration(stack, entity) - timeLeft;
        float power = LongbowItem.getPowerForTime(charge);
        if (power < 0.1f) {
            return;
        }
        boolean bl = infinite = player.getAbilities().instabuild || ammoStack.is(Items.ARROW) && this.hasInfinityEnchantment(stack, level, (LivingEntity)player);
        if (!level.isClientSide) {
            ItemStack usedAmmo = ammoStack.isEmpty() ? new ItemStack((ItemLike)Items.ARROW) : ammoStack;
            AbstractArrow arrow = this.createArrow(level, (LivingEntity)player, stack, usedAmmo);
            arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, power * 4.0f, 1.0f);
            arrow.setBaseDamage(arrow.getBaseDamage() * 1.75);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                EnchantmentHelper.onProjectileSpawned((ServerLevel)serverLevel, (ItemStack)stack, (AbstractArrow)arrow, null);
            }
            if (infinite) {
                arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            level.addFreshEntity((Entity)arrow);
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + power * 0.5f);
        stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!infinite && !player.getAbilities().instabuild) {
            ammoStack.shrink(1);
            if (ammoStack.isEmpty()) {
                player.getInventory().removeItem(ammoStack);
            }
        }
    }

    private boolean hasInfinityEnchantment(ItemStack stack, Level level, LivingEntity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return EnchantmentHelper.getEnchantmentLevel((Holder)serverLevel.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.INFINITY), (LivingEntity)entity) > 0;
        }
        return false;
    }

    protected AbstractArrow createArrow(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo) {
        Item item = ammo.getItem();
        if (item instanceof ArrowItem) {
            ArrowItem arrowItem = (ArrowItem)item;
            return arrowItem.createArrow(level, ammo, shooter, weapon);
        }
        return ProjectileUtil.getMobArrow((LivingEntity)shooter, (ItemStack)weapon, (float)2.0f, (ItemStack)ammo);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public static float getPowerForTime(int charge) {
        float f = (float)charge / 30.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean hasAmmo;
        ItemStack stack = player.getItemInHand(hand);
        boolean bl = hasAmmo = !player.getProjectile(stack).isEmpty();
        if (!player.getAbilities().instabuild && !hasAmmo) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }
}

