/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.init;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mcreator.valarian_conquest.ValarianConquestMod;
import net.mcreator.valarian_conquest.init.ValarianConquestModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber
public class ValarianConquestModVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((ResourceKey)Registries.VILLAGER_PROFESSION, (String)"valarian_conquest");
    public static final DeferredHolder<VillagerProfession, VillagerProfession> BARBER_SURGEON_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("barber_surgeon_profession", () -> (Block)ValarianConquestModBlocks.BARBER_SURGEON.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.zombie_villager.cure")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> BUILDER_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("builder_profession", () -> (Block)ValarianConquestModBlocks.BUILDER.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_toolsmith")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> SIEGE_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("siege_profession", () -> (Block)ValarianConquestModBlocks.SIEGE.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_toolsmith")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> WEAPONSMITH_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("weaponsmith_profession", () -> (Block)ValarianConquestModBlocks.WEAPONSMITH.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_toolsmith")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> ARMORSMITH_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("armorsmith_profession", () -> (Block)ValarianConquestModBlocks.ARMORSMITH.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_toolsmith")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> SCRIBE_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("scribe_profession", () -> (Block)ValarianConquestModBlocks.SCRIBE.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_cartographer")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> VALARIAN_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("valarian_profession", () -> (Block)ValarianConquestModBlocks.VALARIAN.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> BOHEMIAN_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("bohemian_profession", () -> (Block)ValarianConquestModBlocks.BOHEMIAN.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> CALADRIAN_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("caladrian_profession", () -> (Block)ValarianConquestModBlocks.CALADRIAN.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> NUMERIAN_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("numerian_profession", () -> (Block)ValarianConquestModBlocks.NUMERIAN.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> VISGOTHIAN_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("visgothian_profession", () -> (Block)ValarianConquestModBlocks.VISGOTHIAN.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> GARDONIAN_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("gardonian_profession", () -> (Block)ValarianConquestModBlocks.GARDONIAN.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> GALICIAN_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("galician_profession", () -> (Block)ValarianConquestModBlocks.GALICIAN.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> LANCASTIAN_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("lancastian_profession", () -> (Block)ValarianConquestModBlocks.LANCASTIAN.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> HOSPITALLER_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("hospitaller_profession", () -> (Block)ValarianConquestModBlocks.HOSPITALLER.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> TEMPLAR_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("templar_profession", () -> (Block)ValarianConquestModBlocks.TEMPLAR.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> BARATHIAN_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("barathian_profession", () -> (Block)ValarianConquestModBlocks.BARATHIAN.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> ORLEANIAN_PROFESSION = ValarianConquestModVillagerProfessions.registerProfession("orleanian_profession", () -> (Block)ValarianConquestModBlocks.ORLEANIAN.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:empty_audio")));

    private static DeferredHolder<VillagerProfession, VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            Predicate<Holder> poiPredicate = poiTypeHolder -> ValarianConquestModVillagerProfessions.POI_TYPES.get((Object)name).poiType != null && poiTypeHolder.value() == ValarianConquestModVillagerProfessions.POI_TYPES.get((Object)name).poiType.value();
            return new VillagerProfession("valarian_conquest:" + name, poiPredicate, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegisterEvent event) {
        event.register(Registries.POINT_OF_INTEREST_TYPE, registerHelper -> {
            for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
                Block block = entry.getValue().block.get();
                String name = entry.getKey();
                Optional existingCheck = PoiTypes.forState((BlockState)block.defaultBlockState());
                if (existingCheck.isPresent()) {
                    ValarianConquestMod.LOGGER.error("Skipping villager profession " + name + " that uses POI block " + String.valueOf(block) + " that is already in use by " + String.valueOf(existingCheck));
                    continue;
                }
                PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)block.getStateDefinition().getPossibleStates()), 1, 1);
                registerHelper.register(ResourceLocation.fromNamespaceAndPath((String)"valarian_conquest", (String)name), (Object)poiType);
                entry.getValue().poiType = BuiltInRegistries.POINT_OF_INTEREST_TYPE.wrapAsHolder((Object)poiType);
            }
        });
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        Holder<PoiType> poiType;

        ProfessionPoiType(Supplier<Block> block, Holder<PoiType> poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

