/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.entity;

import net.mcreator.valarian_conquest.api.ISheatheable;
import net.mcreator.valarian_conquest.procedures.NotIsAggressiveAnimationProcedureProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class SoldierEntity
extends Monster
implements ISheatheable {
    public final AnimationState animationState0 = new AnimationState();
    private static final EntityDataAccessor<Integer> DATA_SHEATHE_STATE = SynchedEntityData.defineId(SoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.defineId(SoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static int nextVariant = 1;

    public SoldierEntity(EntityType<SoldierEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
        this.setPersistenceRequired();
        if (!world.isClientSide) {
            this.setTextureVariant(nextVariant);
            if (++nextVariant > 24) {
                nextVariant = 1;
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SHEATHE_STATE, (Object)0);
        builder.define(TEXTURE_VARIANT, (Object)1);
    }

    @Override
    public int getSheatheState() {
        return (Integer)this.entityData.get(DATA_SHEATHE_STATE);
    }

    @Override
    public void setSheatheState(int state) {
        this.entityData.set(DATA_SHEATHE_STATE, (Object)state);
    }

    public void setTextureVariant(int variant) {
        this.entityData.set(TEXTURE_VARIANT, (Object)variant);
    }

    public int getTextureVariant() {
        return (Integer)this.entityData.get(TEXTURE_VARIANT);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("sheatheState", this.getSheatheState());
        tag.putInt("TextureVariant", this.getTextureVariant());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("sheatheState")) {
            this.setSheatheState(tag.getInt("sheatheState"));
        }
        if (tag.contains("TextureVariant")) {
            this.setTextureVariant(tag.getInt("TextureVariant"));
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, true, entity -> {
            if (entity instanceof Player || entity instanceof Monster) {
                return true;
            }
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                CompoundTag persistent = this.getPersistentData();
                return persistent == null || !persistent.getBoolean("claimed_citizen");
            }
            return false;
        }){

            public boolean canContinueToUse() {
                LivingEntity livingEntity = this.target;
                if (livingEntity instanceof Villager) {
                    Villager villager = (Villager)livingEntity;
                    CompoundTag persistent = SoldierEntity.this.getPersistentData();
                    if (persistent != null && persistent.getBoolean("claimed_citizen")) {
                        return false;
                    }
                }
                return super.canContinueToUse();
            }
        });
        this.targetSelector.addGoal(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.0, false){

            protected double getAttackReachSqr(LivingEntity entity) {
                return 3.61;
            }
        });
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public double getPassengersRidingOffset() {
        return -0.35;
    }

    protected SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.fromNamespaceAndPath((String)"valarian_conquest", (String)"malehurt"));
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.fromNamespaceAndPath((String)"valarian_conquest", (String)"maledie"));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(NotIsAggressiveAnimationProcedureProcedure.execute((Entity)this), this.tickCount);
        }
        if (this.isInWater() && !this.isInLava()) {
            double baseSpeed = 0.25;
            double boostedSpeed = 0.7;
            if (this.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue() != boostedSpeed) {
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(boostedSpeed);
            }
        } else {
            double normalSpeed = 0.25;
            if (this.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue() != normalSpeed) {
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(normalSpeed);
            }
        }
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.FOLLOW_RANGE, 32.0);
    }
}

