/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.entity;

import javax.annotation.Nullable;
import net.mcreator.valarian_conquest.procedures.BallistaSpawnRotateProcedureProcedure;
import net.mcreator.valarian_conquest.procedures.CannonAnimationLogicProcedure;
import net.mcreator.valarian_conquest.procedures.CannonLaunchBallProcedureProcedure;
import net.mcreator.valarian_conquest.procedures.IsMovingAnimationProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class CannonEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_cannonshoot = SynchedEntityData.defineId(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    private float riderYawOffset = 0.0f;

    public CannonEntity(EntityType<CannonEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_cannonshoot, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, true, entity -> {
            boolean validType = false;
            if (entity instanceof Player || entity instanceof Monster) {
                validType = true;
            } else if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                CompoundTag persistent = this.getPersistentData();
                boolean bl = validType = persistent == null || !persistent.getBoolean("claimed_citizen");
            }
            if (!validType) {
                return false;
            }
            return this.isInFrontArc((Entity)entity, 180.0);
        }){

            protected AABB getTargetSearchArea(double targetDistance) {
                return this.mob.getBoundingBox().inflate(targetDistance, 20.0, targetDistance);
            }

            public boolean canContinueToUse() {
                if (this.target != null && !CannonEntity.this.isInFrontArc((Entity)this.target, 180.0)) {
                    return false;
                }
                LivingEntity livingEntity = this.target;
                if (livingEntity instanceof Villager) {
                    Villager villager = (Villager)livingEntity;
                    CompoundTag persistent = CannonEntity.this.getPersistentData();
                    if (persistent != null && persistent.getBoolean("claimed_citizen")) {
                        return false;
                    }
                }
                return super.canContinueToUse();
            }
        });
    }

    private boolean isInFrontArc(Entity target, double arcDegrees) {
        double angleDiff;
        double dx = target.getX() - this.getX();
        double dz = target.getZ() - this.getZ();
        double angleToTarget = Math.toDegrees(Math.atan2(-dx, dz));
        double cannonYaw = this.getYRot();
        for (angleDiff = angleToTarget - cannonYaw; angleDiff > 180.0; angleDiff -= 360.0) {
        }
        while (angleDiff < -180.0) {
            angleDiff += 360.0;
        }
        return Math.abs(angleDiff) <= arcDegrees / 2.0;
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        sourceentity.startRiding((Entity)this);
        this.riderYawOffset = this.getYRot();
        return retval;
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        super.positionRider(passenger, moveFunction);
        if (this.hasPassenger(passenger)) {
            LivingEntity living;
            float yawRad = this.getYRot() * ((float)Math.PI / 180);
            double offsetX = Math.sin(yawRad) * 1.25;
            double offsetZ = -Math.cos(yawRad) * 1.25;
            double riderX = this.getX() + offsetX;
            double riderY = this.getY() + (double)this.getBbHeight() * 0.75 - 1.1;
            double riderZ = this.getZ() + offsetZ;
            moveFunction.accept(passenger, riderX, riderY, riderZ);
            if (passenger instanceof LivingEntity && (living = (LivingEntity)passenger) instanceof Mob) {
                Mob mob = (Mob)living;
                living.setYRot(this.getYRot());
                living.setXRot(this.getXRot());
                living.yRotO = living.getYRot();
                living.xRotO = living.getXRot();
                living.setDeltaMovement(Vec3.ZERO);
                mob.setNoAi(true);
            }
        }
    }

    public void removePassenger(Entity passenger) {
        LivingEntity living;
        super.removePassenger(passenger);
        if (passenger instanceof LivingEntity && (living = (LivingEntity)passenger) instanceof Mob) {
            Mob mob = (Mob)living;
            mob.setNoAi(false);
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, -0.75, 0.0);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:seige_breaking"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        BallistaSpawnRotateProcedureProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datacannonshoot", ((Boolean)this.entityData.get(DATA_cannonshoot)).booleanValue());
        compound.putFloat("RiderYawOffset", this.riderYawOffset);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datacannonshoot")) {
            this.entityData.set(DATA_cannonshoot, (Object)compound.getBoolean("Datacannonshoot"));
        }
        if (compound.contains("RiderYawOffset")) {
            this.riderYawOffset = compound.getFloat("RiderYawOffset");
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(IsMovingAnimationProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(CannonAnimationLogicProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        CannonLaunchBallProcedureProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void travel(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
        if (this.isVehicle() && entity instanceof Player) {
            Player player = (Player)entity;
            this.setYRot(player.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(player.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yBodyRot = player.getYRot();
            this.yHeadRot = player.getYRot();
            this.setSpeed(0.025f);
            float forward = player.zza;
            float strafe = player.xxa;
            super.travel(new Vec3((double)strafe, 0.0, (double)forward));
            double dX = this.getX() - this.xo;
            double dZ = this.getZ() - this.zo;
            float f = (float)Math.sqrt(dX * dX + dZ * dZ) * 4.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            this.walkAnimation.setSpeed(this.walkAnimation.speed() + (f - this.walkAnimation.speed()) * 0.4f);
            this.walkAnimation.position(this.walkAnimation.position() + this.walkAnimation.speed());
            this.calculateEntityAnimation(true);
            return;
        }
        super.travel(dir);
    }

    public boolean canCollideWith(Entity entity) {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.025);
        builder = builder.add(Attributes.MAX_HEALTH, 25.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 5.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 48.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 5.0);
        return builder;
    }
}

