/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.entity;

import net.mcreator.valarian_conquest.init.ValarianConquestModEntities;
import net.mcreator.valarian_conquest.init.ValarianConquestModItems;
import net.mcreator.valarian_conquest.procedures.CannonBallProjectileProjectileHitsBlockProcedure;
import net.mcreator.valarian_conquest.procedures.CannonBallProjectileWhileProjectileFlyingTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class CannonBallProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)ValarianConquestModItems.CANNON_BALL.get());

    public CannonBallProjectileEntity(EntityType<? extends CannonBallProjectileEntity> type, Level level) {
        super(type, level);
    }

    public CannonBallProjectileEntity(EntityType<? extends CannonBallProjectileEntity> type, double x, double y, double z, Level level, ItemStack pickupItemStack) {
        super(type, x, y, z, level, pickupItemStack, pickupItemStack);
    }

    public CannonBallProjectileEntity(EntityType<? extends CannonBallProjectileEntity> type, LivingEntity shooter, Level level, ItemStack pickupItemStack) {
        super(type, shooter, level, pickupItemStack, pickupItemStack);
    }

    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return PROJECTILE_ITEM;
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void onHitEntity(EntityHitResult hit) {
        super.onHitEntity(hit);
        CannonBallProjectileProjectileHitsBlockProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void onHitBlock(BlockHitResult hit) {
        super.onHitBlock(hit);
        CannonBallProjectileProjectileHitsBlockProcedure.execute((LevelAccessor)this.level(), hit.getBlockPos().getX(), hit.getBlockPos().getY(), hit.getBlockPos().getZ());
    }

    public boolean isNoGravity() {
        return true;
    }

    public void tick() {
        if (!this.inGround) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.02, 0.0));
        }
        super.tick();
        CannonBallProjectileWhileProjectileFlyingTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
        if (this.inGround) {
            this.discard();
        }
    }

    public static CannonBallProjectileEntity shoot(Level level, LivingEntity shooter, RandomSource random) {
        return CannonBallProjectileEntity.shoot(level, shooter, random, 2.0f, 25.0, 3);
    }

    public static CannonBallProjectileEntity shoot(Level level, LivingEntity shooter, RandomSource random, float pullingPower) {
        return CannonBallProjectileEntity.shoot(level, shooter, random, pullingPower * 2.0f, 25.0, 3);
    }

    public static CannonBallProjectileEntity shoot(Level level, LivingEntity shooter, RandomSource random, float power, double damage, int knockback) {
        CannonBallProjectileEntity proj = new CannonBallProjectileEntity((EntityType<? extends CannonBallProjectileEntity>)((EntityType)ValarianConquestModEntities.CANNON_BALL_PROJECTILE.get()), shooter, level, PROJECTILE_ITEM.copy());
        proj.shoot(shooter.getViewVector((float)1.0f).x, shooter.getViewVector((float)1.0f).y, shooter.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        proj.setSilent(true);
        proj.setCritArrow(false);
        proj.setBaseDamage(damage);
        level.addFreshEntity((Entity)proj);
        level.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:cannonfire")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return proj;
    }

    public static CannonBallProjectileEntity shoot(LivingEntity shooter, LivingEntity target) {
        Level level = shooter.level();
        CannonBallProjectileEntity proj = new CannonBallProjectileEntity((EntityType<? extends CannonBallProjectileEntity>)((EntityType)ValarianConquestModEntities.CANNON_BALL_PROJECTILE.get()), shooter, level, PROJECTILE_ITEM.copy());
        double dx = target.getX() - shooter.getX();
        double dz = target.getZ() - shooter.getZ();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        proj.shoot(dx, dy - proj.getY() + Math.hypot(dx, dz) * 0.25, dz, 4.0f, 12.0f);
        proj.setSilent(true);
        proj.setBaseDamage(25.0);
        proj.setCritArrow(false);
        level.addFreshEntity((Entity)proj);
        level.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:cannonfire")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return proj;
    }
}

