/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.entity;

import net.mcreator.valarian_conquest.api.ISheatheable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ArcherEntity
extends Monster
implements RangedAttackMob,
ISheatheable {
    private static final EntityDataAccessor<Integer> DATA_SHEATHE_STATE = SynchedEntityData.defineId(ArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.defineId(ArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.defineId(ArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CROSSBOW_CHARGED = SynchedEntityData.defineId(ArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_AIMING = SynchedEntityData.defineId(ArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static int nextVariant = 1;

    public ArcherEntity(EntityType<ArcherEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
        this.setPersistenceRequired();
        if (!world.isClientSide) {
            this.setTextureVariant(nextVariant);
            if (++nextVariant > 24) {
                nextVariant = 1;
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SHEATHE_STATE, (Object)0);
        builder.define(TEXTURE_VARIANT, (Object)1);
        builder.define(IS_CHARGING_CROSSBOW, (Object)false);
        builder.define(CROSSBOW_CHARGED, (Object)false);
        builder.define(IS_AIMING, (Object)false);
    }

    @Override
    public int getSheatheState() {
        return (Integer)this.entityData.get(DATA_SHEATHE_STATE);
    }

    @Override
    public void setSheatheState(int state) {
        this.entityData.set(DATA_SHEATHE_STATE, (Object)state);
    }

    public void setChargingCrossbow(boolean charging) {
        this.entityData.set(IS_CHARGING_CROSSBOW, (Object)charging);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.entityData.get(IS_CHARGING_CROSSBOW);
    }

    public void setCrossbowCharged(boolean charged) {
        this.entityData.set(CROSSBOW_CHARGED, (Object)charged);
    }

    public boolean isCrossbowCharged() {
        return (Boolean)this.entityData.get(CROSSBOW_CHARGED);
    }

    public void setAiming(boolean aiming) {
        this.entityData.set(IS_AIMING, (Object)aiming);
    }

    public boolean isAiming() {
        return (Boolean)this.entityData.get(IS_AIMING);
    }

    public void setTextureVariant(int variant) {
        this.entityData.set(TEXTURE_VARIANT, (Object)variant);
    }

    public int getTextureVariant() {
        return (Integer)this.entityData.get(TEXTURE_VARIANT);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("sheatheState", this.getSheatheState());
        tag.putInt("TextureVariant", this.getTextureVariant());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("sheatheState")) {
            this.setSheatheState(tag.getInt("sheatheState"));
        }
        if (tag.contains("TextureVariant")) {
            this.setTextureVariant(tag.getInt("TextureVariant"));
        }
    }

    public boolean isHoldingRangedWeapon() {
        return this.getMainHandItem().getItem() instanceof BowItem || this.getMainHandItem().getItem() instanceof CrossbowItem || this.getOffhandItem().getItem() instanceof BowItem || this.getOffhandItem().getItem() instanceof CrossbowItem;
    }

    public boolean isHoldingCrossbow() {
        return this.getMainHandItem().getItem() instanceof CrossbowItem || this.getOffhandItem().getItem() instanceof CrossbowItem;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new CustomRangedAttackGoal(this, 0.75, 60, 32.0f));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, true, entity -> {
            if (entity instanceof Player || entity instanceof Monster) {
                return true;
            }
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                CompoundTag persistent = this.getPersistentData();
                return persistent == null || !persistent.getBoolean("claimed_citizen");
            }
            return false;
        }){

            protected AABB getTargetSearchArea(double targetDistance) {
                return this.mob.getBoundingBox().inflate(targetDistance, 20.0, targetDistance);
            }

            public boolean canContinueToUse() {
                LivingEntity livingEntity = this.target;
                if (livingEntity instanceof Villager) {
                    Villager villager = (Villager)livingEntity;
                    CompoundTag persistent = ArcherEntity.this.getPersistentData();
                    if (persistent != null && persistent.getBoolean("claimed_citizen")) {
                        return false;
                    }
                }
                return super.canContinueToUse();
            }
        });
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, (double)-0.35f, 0.0);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:malehurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:maledie"));
    }

    public void aiStep() {
        super.aiStep();
        LivingEntity target = this.getTarget();
        if (target != null) {
            float yawDifference;
            this.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            for (yawDifference = this.yHeadRot - this.yBodyRot; yawDifference < -180.0f; yawDifference += 360.0f) {
            }
            while (yawDifference >= 180.0f) {
                yawDifference -= 360.0f;
            }
            this.yBodyRot += yawDifference * 0.3f;
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        ItemStack mainHand = this.getMainHandItem();
        ItemStack offHand = this.getOffhandItem();
        if (mainHand.getItem() instanceof CrossbowItem) {
            this.performCrossbowAttack((LivingEntity)this, target, mainHand, 1.6f);
        } else if (offHand.getItem() instanceof CrossbowItem) {
            this.performCrossbowAttack((LivingEntity)this, target, offHand, 1.6f);
        } else {
            this.performBowAttack(target, distanceFactor);
        }
    }

    private void performBowAttack(LivingEntity target, float distanceFactor) {
        Arrow arrow = new Arrow(EntityType.ARROW, this.level());
        Vec3 lookVec = this.getViewVector(1.0f);
        double spawnDist = 1.0;
        double spawnX = this.getX() + lookVec.x * spawnDist;
        double spawnY = this.getEyeY() - 0.1;
        double spawnZ = this.getZ() + lookVec.z * spawnDist;
        arrow.setPos(spawnX, spawnY, spawnZ);
        arrow.setOwner((Entity)this);
        arrow.setBaseDamage(4.0);
        arrow.pickup = AbstractArrow.Pickup.ALLOWED;
        double dx = target.getX() - arrow.getX();
        double dy = target.getY() + (double)target.getBbHeight() * 0.5 - arrow.getY();
        double dz = target.getZ() - arrow.getZ();
        double distHoriz = Math.sqrt(dx * dx + dz * dz);
        float velocity = Math.min(3.0f, 1.0f + (float)distHoriz / 15.0f);
        arrow.shoot(dx, dy + distHoriz * 0.15, dz, velocity, 1.0f);
        this.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)arrow);
    }

    private void performCrossbowAttack(LivingEntity shooter, LivingEntity target, ItemStack crossbow, float velocity) {
        AbstractArrow arrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)Items.ARROW.getDefaultInstance(), (float)1.6f, (ItemStack)crossbow);
        Vec3 lookVec = this.getViewVector(1.0f);
        double spawnDist = 1.0;
        double spawnX = this.getX() + lookVec.x * spawnDist;
        double spawnY = this.getEyeY() - 0.1;
        double spawnZ = this.getZ() + lookVec.z * spawnDist;
        arrow.setPos(spawnX, spawnY, spawnZ);
        arrow.setOwner((Entity)this);
        arrow.pickup = AbstractArrow.Pickup.ALLOWED;
        double dx = target.getX() - arrow.getX();
        double dy = target.getY() + (double)target.getBbHeight() * 0.5 - arrow.getY();
        double dz = target.getZ() - arrow.getZ();
        double distHoriz = Math.sqrt(dx * dx + dz * dz);
        arrow.shoot(dx, dy + distHoriz * 0.2, dz, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.CROSSBOW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)arrow);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.STEP_HEIGHT, 0.6);
    }

    private static class CustomRangedAttackGoal
    extends RangedAttackGoal {
        private final ArcherEntity archer;
        private final double speedModifier;
        private int attackTime = -1;
        private int seeTime;
        private int aimingTicks = 0;
        private boolean crossbowCharged = false;

        public CustomRangedAttackGoal(ArcherEntity mob, double speedModifier, int attackInterval, float attackRadius) {
            super((RangedAttackMob)mob, speedModifier, attackInterval, attackRadius);
            this.archer = mob;
            this.speedModifier = speedModifier;
        }

        public boolean canUse() {
            boolean canUse;
            boolean bl = canUse = super.canUse() && this.archer.isHoldingRangedWeapon();
            if (canUse) {
                this.archer.setAiming(true);
            }
            return canUse;
        }

        public void start() {
            ItemStack weapon;
            super.start();
            this.attackTime = -1;
            this.seeTime = 0;
            this.crossbowCharged = false;
            this.aimingTicks = 0;
            this.archer.setAiming(true);
            this.archer.setChargingCrossbow(false);
            this.archer.setCrossbowCharged(false);
            ItemStack itemStack = weapon = this.archer.getMainHandItem().getItem() instanceof BowItem || this.archer.getMainHandItem().getItem() instanceof CrossbowItem ? this.archer.getMainHandItem() : this.archer.getOffhandItem();
            if (!weapon.isEmpty()) {
                this.archer.startUsingItem(weapon == this.archer.getMainHandItem() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                if (this.archer.isHoldingCrossbow()) {
                    this.archer.setChargingCrossbow(true);
                }
            }
        }

        public void stop() {
            super.stop();
            this.archer.stopUsingItem();
            this.archer.setChargingCrossbow(false);
            this.archer.setCrossbowCharged(false);
            this.archer.setAiming(false);
            this.crossbowCharged = false;
            this.aimingTicks = 0;
        }

        public void tick() {
            LivingEntity target = this.archer.getTarget();
            if (target == null) {
                return;
            }
            double distSq = this.archer.distanceToSqr(target.getX(), target.getY(), target.getZ());
            boolean canSee = this.archer.getSensing().hasLineOfSight((Entity)target);
            this.seeTime = canSee ? ++this.seeTime : 0;
            this.archer.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            this.archer.setYBodyRot(this.archer.getYHeadRot());
            if (distSq <= 1024.0 && this.seeTime >= 5) {
                this.archer.getNavigation().stop();
            } else {
                this.archer.getNavigation().moveTo((Entity)target, this.speedModifier);
            }
            if (--this.attackTime == 0) {
                ItemStack weapon;
                if (!canSee) {
                    this.attackTime = 60;
                    return;
                }
                this.archer.setAiming(true);
                ItemStack itemStack = weapon = this.archer.getMainHandItem().getItem() instanceof BowItem || this.archer.getMainHandItem().getItem() instanceof CrossbowItem ? this.archer.getMainHandItem() : this.archer.getOffhandItem();
                if (!weapon.isEmpty()) {
                    this.archer.startUsingItem(weapon == this.archer.getMainHandItem() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                    if (this.archer.isHoldingCrossbow()) {
                        this.archer.setChargingCrossbow(true);
                        this.archer.setCrossbowCharged(false);
                        this.crossbowCharged = false;
                        this.aimingTicks = 0;
                    }
                }
                this.attackTime = -1;
            } else if (this.attackTime < 0) {
                int useTime = this.archer.getTicksUsingItem();
                if (useTime == 0 || !this.archer.isUsingItem()) {
                    ItemStack weapon;
                    ItemStack itemStack = weapon = this.archer.getMainHandItem().getItem() instanceof BowItem || this.archer.getMainHandItem().getItem() instanceof CrossbowItem ? this.archer.getMainHandItem() : this.archer.getOffhandItem();
                    if (!weapon.isEmpty()) {
                        this.archer.startUsingItem(weapon == this.archer.getMainHandItem() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                    }
                }
                if (this.archer.isHoldingCrossbow()) {
                    if (!this.crossbowCharged) {
                        if (useTime >= 25) {
                            this.archer.setChargingCrossbow(false);
                            this.archer.setCrossbowCharged(true);
                            this.crossbowCharged = true;
                            this.aimingTicks = 0;
                        }
                    } else {
                        ++this.aimingTicks;
                        if (this.aimingTicks >= 15) {
                            float distFactor = (float)Math.sqrt(distSq) / 32.0f;
                            this.archer.performRangedAttack(target, distFactor);
                            this.archer.stopUsingItem();
                            this.archer.setCrossbowCharged(false);
                            this.archer.setChargingCrossbow(false);
                            this.archer.setAiming(false);
                            this.attackTime = 60;
                            this.crossbowCharged = false;
                            this.aimingTicks = 0;
                        }
                    }
                } else if (useTime >= 20) {
                    float distFactor = (float)Math.sqrt(distSq) / 32.0f;
                    this.archer.performRangedAttack(target, distFactor);
                    this.archer.stopUsingItem();
                    this.archer.setAiming(false);
                    this.attackTime = 60;
                }
            }
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }
    }
}

