/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.valarian_conquest.client.model.animations.Entity_AnimationsAnimation;
import net.mcreator.valarian_conquest.client.renderer.layer.SheathItemsLayer;
import net.mcreator.valarian_conquest.entity.SoldierEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.UseAnim;

public class SoldierRenderer
extends HumanoidMobRenderer<SoldierEntity, HumanoidModel<SoldierEntity>> {
    public SoldierRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new AnimatedModel(context.bakeLayer(ModelLayers.PLAYER)), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        this.layers.removeIf(layer -> layer instanceof ItemInHandLayer);
        ItemInHandRenderer handRenderer = context.getItemInHandRenderer();
        this.addLayer(new SheathItemsLayer(this, handRenderer));
    }

    public ResourceLocation getTextureLocation(SoldierEntity entity) {
        int variant = entity.getTextureVariant();
        return ResourceLocation.fromNamespaceAndPath((String)"valarian_conquest", (String)("textures/entities/male_citizen_" + variant + ".png"));
    }

    private static final class AnimatedModel
    extends HumanoidModel<SoldierEntity> {
        private final ModelPart root;
        private final ModelPart jacket;
        private final ModelPart leftSleeve;
        private final ModelPart rightSleeve;
        private final ModelPart leftPants;
        private final ModelPart rightPants;
        private final HierarchicalModel<SoldierEntity> animator = new HierarchicalModel<SoldierEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(SoldierEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.animate(entity.animationState0, Entity_AnimationsAnimation.holdspear, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
            this.jacket = root.getChild("jacket");
            this.leftSleeve = root.getChild("left_sleeve");
            this.rightSleeve = root.getChild("right_sleeve");
            this.leftPants = root.getChild("left_pants");
            this.rightPants = root.getChild("right_pants");
            this.jacket.visible = true;
            this.leftSleeve.visible = true;
            this.rightSleeve.visible = true;
            this.leftPants.visible = true;
            this.rightPants.visible = true;
        }

        public void setupAnim(SoldierEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (entity.isUsingItem() && entity.getUseItem().getUseAnimation() == UseAnim.BLOCK) {
                if (entity.getUsedItemHand() == InteractionHand.OFF_HAND) {
                    this.leftArm.xRot = -0.9424778f;
                    this.leftArm.yRot = 0.5235988f;
                } else {
                    this.rightArm.xRot = -0.9424778f;
                    this.rightArm.yRot = -0.5235988f;
                }
            }
            this.jacket.copyFrom(this.body);
            this.leftSleeve.copyFrom(this.leftArm);
            this.rightSleeve.copyFrom(this.rightArm);
            this.leftPants.copyFrom(this.leftLeg);
            this.rightPants.copyFrom(this.rightLeg);
        }

        public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
            super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
            this.jacket.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.leftSleeve.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.rightSleeve.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.leftPants.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.rightPants.render(poseStack, buffer, packedLight, packedOverlay, color);
        }
    }
}

