/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.zeith.hammerlib.api.fml.IRegisterListener;
import org.zeith.squarry.blocks.entity.TilePoweredQuarry;
import org.zeith.squarry.items.ItemBaseSQ;

public abstract class ItemUpgrade
extends ItemBaseSQ
implements IRegisterListener {
    private static final List<ItemUpgrade> UPGRADE_LIST = new ArrayList<ItemUpgrade>();
    public static final List<ItemUpgrade> ALL_UPGRADES = Collections.unmodifiableList(UPGRADE_LIST);
    protected float quarryUseMultiplier = 1.0f;
    public float quarryUseMultiplierServer = 1.0f;
    public float quarryUseMultiplierClient = 1.0f;

    public ItemUpgrade(Item.Properties props) {
        super(props);
    }

    public float getBaseQuarryUseMultiplier() {
        return this.quarryUseMultiplier;
    }

    public void onPostRegistered() {
        UPGRADE_LIST.add(this);
        this.quarryUseMultiplierClient = this.quarryUseMultiplierServer = this.quarryUseMultiplier;
    }

    public void addEnchantments(TilePoweredQuarry quarry, ItemEnchantments.Mutable enchantmentMap) {
    }

    public void handleDrops(TilePoweredQuarry quarry, BlockPos pos, NonNullList<ItemStack> drops) {
    }

    public boolean canStay(TilePoweredQuarry quarry, int index) {
        return true;
    }

    public ItemStack handlePickup(ItemStack stack, TilePoweredQuarry quarry, int index) {
        return stack;
    }

    public boolean isCompatible(TilePoweredQuarry quarry) {
        return true;
    }

    public void tick(TilePoweredQuarry quarry, int index) {
    }

    public static boolean hasUpgrade(TilePoweredQuarry quarry, ItemUpgrade upgrade) {
        for (ItemUpgrade up : quarry.getUpgrades()) {
            if (up != upgrade) continue;
            return true;
        }
        return false;
    }
}

