/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.items;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import org.zeith.squarry.SQConfig;
import org.zeith.squarry.SimpleQuarry;
import org.zeith.squarry.blocks.entity.TilePoweredQuarry;
import org.zeith.squarry.items.ItemUpgrade;

@EventBusSubscriber
public class ItemUnificationUpgrade
extends ItemUpgrade {
    private static Multimap<TagKey<Item>, Item> UNIFIED_OBJECTS = ArrayListMultimap.create();
    private static Map<Item, Item> UNIFICATION_MAP = Map.of();

    public ItemUnificationUpgrade() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public void handleDrops(TilePoweredQuarry quarry, BlockPos pos, NonNullList<ItemStack> drops) {
        if (!SQConfig.isEnableUnification()) {
            return;
        }
        drops.replaceAll(stack -> {
            Item it = stack.getItem();
            Item uit = UNIFICATION_MAP.get(it);
            if (uit != null) {
                return new ItemStack((ItemLike)uit, stack.getCount());
            }
            return stack;
        });
    }

    @SubscribeEvent
    public static void tagsRefresh(TagsUpdatedEvent e) {
        if (!e.shouldUpdateStaticData()) {
            return;
        }
        Registry items = e.getRegistryAccess().registryOrThrow(Registries.ITEM);
        Set excludedTags = Arrays.stream(SQConfig.getExcludedUnificationEntries()).filter(s -> s.startsWith("#")).map(s -> s.substring(1)).map(ResourceLocation::tryParse).filter(Objects::nonNull).map(ItemTags::create).collect(Collectors.toSet());
        Set excludedItems = Arrays.stream(SQConfig.getExcludedUnificationEntries()).filter(s -> !s.startsWith("#")).map(ResourceLocation::tryParse).filter(Objects::nonNull).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).collect(Collectors.toSet());
        String[] materials = SQConfig.getAllowedUnificationMaterials();
        ArrayListMultimap uniObjects = ArrayListMultimap.create();
        items.getTags().filter(t -> ItemUnificationUpgrade.canBeUnified(materials, (TagKey<Item>)((TagKey)t.getFirst()))).filter(t -> !excludedTags.contains(t.getFirst())).map(Pair::getSecond).forEach(tag -> uniObjects.putAll((Object)tag.key(), tag.stream().map(Holder::value).filter(it -> !excludedItems.contains(it)).toList()));
        UNIFIED_OBJECTS = uniObjects;
        ArrayListMultimap tagsForItem = ArrayListMultimap.create((int)UNIFIED_OBJECTS.size(), (int)1);
        for (Map.Entry entry : UNIFIED_OBJECTS.entries()) {
            tagsForItem.put((Object)((Item)entry.getValue()), (Object)((TagKey)entry.getKey()));
        }
        tagsForItem.asMap().entrySet().removeIf(c -> {
            Collection tags = (Collection)c.getValue();
            if (tags.size() == 1) {
                return false;
            }
            Item item = (Item)c.getKey();
            SimpleQuarry.LOG.warn("Removed item {} from unification upgrade since it has multiple unification tags: {}", (Object)BuiltInRegistries.ITEM.getKey((Object)item), (Object)tags.stream().map(TagKey::location).map(ResourceLocation::toString).collect(Collectors.joining(", ", "[", "]")));
            for (TagKey tag : tags) {
                UNIFIED_OBJECTS.remove((Object)tag, (Object)item);
            }
            return true;
        });
        ImmutableMap.Builder uniMap = ImmutableMap.builder();
        for (Map.Entry entry : tagsForItem.entries()) {
            Item result;
            Collection cl = UNIFIED_OBJECTS.get((Object)((TagKey)entry.getValue()));
            if (cl.isEmpty() || (result = (Item)cl.iterator().next()) == entry.getKey()) continue;
            uniMap.put((Object)((Item)entry.getKey()), (Object)result);
        }
        UNIFICATION_MAP = uniMap.build();
        SimpleQuarry.LOG.info("Reloaded {} unification items with {} tags.", (Object)UNIFICATION_MAP.size(), (Object)UNIFIED_OBJECTS.keySet().size());
    }

    public static boolean canBeUnified(String[] materials, TagKey<Item> tag) {
        String l = tag.location().toString();
        for (String string : materials) {
            if ((!string.endsWith("/") || !l.startsWith(string)) && !l.equals(string)) continue;
            return true;
        }
        return false;
    }
}

