/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.items;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.zeith.squarry.blocks.entity.TilePoweredQuarry;
import org.zeith.squarry.init.ItemsSQ;
import org.zeith.squarry.items.ItemUpgrade;

public class ItemFortuneUpgrade
extends ItemUpgrade {
    private static final ItemFortuneUpgrade[] upgrades = new ItemFortuneUpgrade[3];
    public int lvl;

    public ItemFortuneUpgrade(int lvl) {
        super(new Item.Properties().stacksTo(1));
        if (upgrades[lvl] == null) {
            ItemFortuneUpgrade.upgrades[lvl] = this;
        }
        this.lvl = lvl;
        this.quarryUseMultiplier = 2.0f;
    }

    @Override
    public void addEnchantments(TilePoweredQuarry quarry, ItemEnchantments.Mutable enchantmentMap) {
        int fortune = 0;
        if (ItemUpgrade.hasUpgrade(quarry, ItemsSQ.UPGRADE_FORTUNE1)) {
            ++fortune;
        }
        if (ItemUpgrade.hasUpgrade(quarry, ItemsSQ.UPGRADE_FORTUNE2) && fortune == 1) {
            ++fortune;
        }
        if (ItemUpgrade.hasUpgrade(quarry, ItemsSQ.UPGRADE_FORTUNE3) && fortune == 2) {
            ++fortune;
        }
        enchantmentMap.set((Holder)quarry.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), fortune);
    }

    @Override
    public boolean isCompatible(TilePoweredQuarry quarry) {
        if (this.lvl > 0 && !ItemFortuneUpgrade.hasUpgrade(quarry, upgrades[this.lvl - 1])) {
            return false;
        }
        return !ItemFortuneUpgrade.hasUpgrade(quarry, this) && !ItemFortuneUpgrade.hasUpgrade(quarry, ItemsSQ.UPGRADE_SILK);
    }

    @Override
    public boolean canStay(TilePoweredQuarry quarry, int index) {
        if (this.lvl > 0 && !ItemFortuneUpgrade.hasUpgrade(quarry, upgrades[this.lvl - 1])) {
            return false;
        }
        return !ItemFortuneUpgrade.hasUpgrade(quarry, ItemsSQ.UPGRADE_SILK);
    }
}

