/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.items;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.zeith.squarry.blocks.entity.TilePoweredQuarry;
import org.zeith.squarry.init.ComponentTypesSQ;
import org.zeith.squarry.init.ItemsSQ;
import org.zeith.squarry.inventory.ContainerFilter;
import org.zeith.squarry.items.ItemUpgrade;
import org.zeith.squarry.items.data.FilterDataComponent;

public class ItemFilterUpgrade
extends ItemUpgrade {
    public ItemFilterUpgrade() {
        super(new Item.Properties().stacksTo(1));
        this.quarryUseMultiplier = 1.0f;
    }

    public FilterDataComponent get(ItemStack stack) {
        return (FilterDataComponent)stack.getOrDefault((DataComponentType)ComponentTypesSQ.FILTER_TYPE.get(), (Object)FilterDataComponent.EMPTY);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            ContainerFilter.openFilter(player, hand);
        }
        return super.use(level, player, hand);
    }

    public static boolean matches(ItemStack filter, ItemStack input) {
        FilterDataComponent filterDataComponent;
        Item item = filter.getItem();
        if (item instanceof ItemFilterUpgrade) {
            ItemFilterUpgrade up = (ItemFilterUpgrade)item;
            filterDataComponent = up.get(filter);
        } else {
            filterDataComponent = FilterDataComponent.EMPTY;
        }
        FilterDataComponent nbt = filterDataComponent;
        boolean invert = nbt.invertList();
        boolean useod = nbt.useTags();
        boolean usemeta = nbt.useDamage();
        boolean ignorenbt = nbt.ignoreComponents();
        boolean applies = false;
        for (ItemStack ft : nbt.filter()) {
            boolean m3;
            if (ft.isEmpty()) continue;
            if (ft.getItem() instanceof ItemFilterUpgrade && ItemFilterUpgrade.matches(ft, input)) {
                applies = true;
                break;
            }
            boolean m1 = useod && ItemFilterUpgrade.matchesByOD(input, ft);
            boolean m0 = ft.getItem() == input.getItem();
            boolean m2 = !usemeta || ft.getDamageValue() == input.getDamageValue();
            boolean bl = m3 = ignorenbt || Objects.equals(ft.getComponents(), input.getComponents());
            if (!m1 && (!m0 || !m2 || !m3)) continue;
            applies = true;
            break;
        }
        return invert != applies;
    }

    public static boolean matchesByOD(ItemStack a, ItemStack b) {
        if (a.isEmpty() && b.isEmpty()) {
            return true;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        Set tagsA = a.getItem().builtInRegistryHolder().tags().collect(Collectors.toSet());
        Set tagsB = b.getItem().builtInRegistryHolder().tags().collect(Collectors.toSet());
        return ItemFilterUpgrade.containsAny(tagsA, tagsB);
    }

    public static <T> boolean containsAny(Collection<T> coll1, Collection<T> coll2) {
        if (coll1.size() < coll2.size()) {
            for (T aColl1 : coll1) {
                if (!coll2.contains(aColl1)) continue;
                return true;
            }
        } else {
            for (T aColl1 : coll2) {
                if (!coll1.contains(aColl1)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFilterUpgrade(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem() == ItemsSQ.UPGRADE_FILTER;
    }

    @Override
    public ItemStack handlePickup(ItemStack stack, TilePoweredQuarry quarry, int index) {
        if (!ItemFilterUpgrade.matches(quarry.getUpgradeStack(index), stack)) {
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @Override
    public boolean isCompatible(TilePoweredQuarry quarry) {
        return !ItemFilterUpgrade.hasUpgrade(quarry, this);
    }
}

