/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.squarry.blocks.entity.TilePoweredQuarry;
import org.zeith.squarry.items.ItemUpgrade;

public class ItemFillerUpgrade
extends ItemUpgrade {
    public ItemFillerUpgrade() {
        super(new Item.Properties().stacksTo(1));
        this.quarryUseMultiplier = 1.5f;
    }

    @Override
    public void handleDrops(TilePoweredQuarry quarry, BlockPos pos, NonNullList<ItemStack> drops) {
        int i;
        ListTag list = quarry.additionalTags.getList("RestorePositions", 4);
        if (list.isEmpty()) {
            quarry.additionalTags.put("RestorePositions", (Tag)list);
        }
        int end = list.size();
        int start = Math.max(0, end - 256);
        long lv = pos.asLong();
        boolean shouldAdd = true;
        for (i = end - 1; i >= start; --i) {
            NumericTag lt;
            Tag tag = list.get(i);
            if (!(tag instanceof NumericTag) || lv != (lt = (NumericTag)tag).getAsLong()) continue;
            shouldAdd = false;
            break;
        }
        if (shouldAdd) {
            list.add((Object)LongTag.valueOf((long)lv));
        }
        for (i = 0; i < drops.size(); ++i) {
            if (!((ItemStack)drops.get(i)).is(ItemTags.DIRT)) continue;
            drops.remove(i);
            --i;
        }
    }

    @Override
    public void tick(TilePoweredQuarry quarry, int index) {
        if (!quarry.isDone() || !quarry.atTickRate(quarry.tickRate)) {
            return;
        }
        ListTag list = quarry.additionalTags.getList("RestorePositions", 4);
        int it = 0;
        Level w = quarry.getLevel();
        if (w != null && !w.isClientSide) {
            while (!list.isEmpty() && ++it <= 512) {
                BlockPos bp;
                NumericTag pos = (NumericTag)Cast.cast((Object)list.remove(list.size() - 1), NumericTag.class);
                if (pos == null || !w.isEmptyBlock(bp = BlockPos.of((long)pos.getAsLong())) && !(w.getBlockState(bp).getBlock() instanceof LiquidBlock)) continue;
                w.setBlock(bp, bp.getY() < 0 ? Blocks.COBBLED_DEEPSLATE.defaultBlockState() : Blocks.COARSE_DIRT.defaultBlockState(), 3);
                break;
            }
        }
        if (list.isEmpty()) {
            quarry.additionalTags.remove("RestorePositions");
        }
    }

    @Override
    public boolean isCompatible(TilePoweredQuarry quarry) {
        return !ItemFillerUpgrade.hasUpgrade(quarry, this);
    }

    @Override
    public boolean canStay(TilePoweredQuarry quarry, int index) {
        return true;
    }
}

