/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.items;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import org.zeith.squarry.blocks.entity.TilePoweredQuarry;
import org.zeith.squarry.init.ItemsSQ;
import org.zeith.squarry.items.ItemUpgrade;

public class ItemAutoSmeltUpgrade
extends ItemUpgrade {
    public ItemAutoSmeltUpgrade() {
        super(new Item.Properties().stacksTo(1));
        this.quarryUseMultiplier = 4.0f;
    }

    @Override
    public void handleDrops(TilePoweredQuarry quarry, BlockPos pos, NonNullList<ItemStack> drops) {
        RecipeManager rm = quarry.getLevel().getRecipeManager();
        for (int i = 0; i < drops.size(); ++i) {
            SingleRecipeInput ctr = new SingleRecipeInput((ItemStack)drops.get(i));
            int j = i;
            RecipeHolder opt = rm.getRecipeFor(RecipeType.SMELTING, (RecipeInput)ctr, quarry.getLevel()).orElse(null);
            if (opt == null) {
                opt = rm.getRecipeFor(RecipeType.BLASTING, (RecipeInput)ctr, quarry.getLevel()).orElse(null);
            }
            Optional.ofNullable(opt).map(RecipeHolder::value).ifPresent(recipe -> {
                ItemStack res = recipe.assemble(ctr, (HolderLookup.Provider)quarry.getLevel().registryAccess());
                if (!res.isEmpty()) {
                    res.setCount(res.getCount() * ((ItemStack)drops.get(j)).getCount());
                    drops.set(j, (Object)res);
                }
            });
        }
    }

    @Override
    public boolean isCompatible(TilePoweredQuarry quarry) {
        return !ItemAutoSmeltUpgrade.hasUpgrade(quarry, this) && !ItemAutoSmeltUpgrade.hasUpgrade(quarry, ItemsSQ.UPGRADE_SILK);
    }

    @Override
    public boolean canStay(TilePoweredQuarry quarry, int index) {
        return !ItemAutoSmeltUpgrade.hasUpgrade(quarry, ItemsSQ.UPGRADE_SILK);
    }
}

