/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.inventory;

import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.zeith.hammerlib.api.forge.ContainerAPI;
import org.zeith.hammerlib.api.inv.IScreenContainer;
import org.zeith.squarry.blocks.entity.TileFuelQuarry;
import org.zeith.squarry.client.screen.ScreenFuelQuarry;
import org.zeith.squarry.inventory.slots.SlotFurnaceFuel;

public class ContainerFuelQuarry
extends AbstractContainerMenu
implements IScreenContainer {
    public TileFuelQuarry tile;

    public ContainerFuelQuarry(Player player, int windowId, TileFuelQuarry tile) {
        super(ContainerAPI.TILE_CONTAINER, windowId);
        int x;
        this.tile = tile;
        for (x = 0; x < 3; ++x) {
            for (int y = 0; y < 9; ++y) {
                this.addSlot(new Slot((Container)player.getInventory(), y + x * 9 + 9, 8 + y * 18, 84 + x * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)player.getInventory(), x, 8 + x * 18, 142));
        }
        this.addSlot(new SlotFurnaceFuel((Container)tile.inventory, 0, 80, 49));
    }

    public boolean stillValid(Player playerIn) {
        return this.tile.getBlockPos().closerToCenterThan((Position)playerIn.position(), 64.0) && !this.tile.isRemoved();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen openScreen(Inventory inv, Component label) {
        return new ScreenFuelQuarry(this, inv, label);
    }

    public ItemStack quickMoveStack(Player player, int slotId) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotId);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slot.container == player.getInventory() ? !this.moveItemStackTo(itemstack1, 36, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 36, true)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

