/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.inventory;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.inv.IScreenContainer;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.squarry.client.screen.ScreenFilter;
import org.zeith.squarry.init.ComponentTypesSQ;
import org.zeith.squarry.inventory.slots.SlotGhost;
import org.zeith.squarry.items.ItemFilterUpgrade;
import org.zeith.squarry.items.data.FilterDataComponent;

@SimplyRegister
public class ContainerFilter
extends AbstractContainerMenu
implements IScreenContainer {
    @RegistryName(value="filter")
    public static final MenuType<ContainerFilter> FILTER = IMenuTypeExtension.create((windowId, playerInv, extraData) -> {
        FilterData tile = new FilterData((FilterDataComponent)FilterDataComponent.STREAM_CODEC.decode((Object)extraData));
        return new ContainerFilter(playerInv, windowId, tile);
    });
    public final Inventory inventory;
    public final FilterData data;

    public ContainerFilter(Inventory inventory, int windowId, FilterData data) {
        super(FILTER, windowId);
        int y;
        int x;
        this.inventory = inventory;
        this.data = data;
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 9; ++y) {
                this.addSlot(new Slot((Container)inventory, y + x * 9 + 9, 8 + y * 18, 84 + x * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 8 + x * 18, 142));
        }
        for (x = 0; x < 4; ++x) {
            for (y = 0; y < 3; ++y) {
                this.addSlot(new SlotGhost((Container)data.inventory, x + y * 4, 53 + x * 18, 17 + y * 18, this::applyToHand));
            }
        }
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id == 0) {
            this.data.invert = !this.data.invert;
            this.applyToHand();
            return true;
        }
        if (id == 1) {
            this.data.useod = !this.data.useod;
            this.applyToHand();
            return true;
        }
        if (id == 2) {
            this.data.usemeta = !this.data.usemeta;
            this.applyToHand();
            return true;
        }
        return false;
    }

    public void applyToHand() {
        for (ItemStack item : this.inventory.items) {
            if (!this.data.isThisFilter(item)) continue;
            item.set((DataComponentType)ComponentTypesSQ.FILTER_TYPE.get(), (Object)this.data.export());
            return;
        }
    }

    public boolean stillValid(Player player) {
        return this.data.isThisFilter(player.getItemInHand(InteractionHand.MAIN_HAND));
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    private static MenuProvider forStack(final ItemStack filter) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return filter.getDisplayName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player player) {
                return new ContainerFilter(player.getInventory(), windowId, new FilterData((FilterDataComponent)filter.getOrDefault((DataComponentType)ComponentTypesSQ.FILTER_TYPE.get(), (Object)FilterDataComponent.EMPTY)));
            }
        };
    }

    public static void openFilter(Player player, InteractionHand hand) {
        DataComponentType type;
        ItemStack hi = player.getItemInHand(hand);
        FilterDataComponent comp = (FilterDataComponent)hi.getOrDefault(type = (DataComponentType)ComponentTypesSQ.FILTER_TYPE.get(), (Object)FilterDataComponent.EMPTY);
        if (Objects.equals(comp.filterId(), FilterDataComponent.EMPTY.filterId())) {
            comp = comp.toBuilder().filterId(UUID.randomUUID()).build();
            hi.set(type, (Object)comp);
        }
        if (!hi.isEmpty() && hi.getItem() instanceof ItemFilterUpgrade && player instanceof ServerPlayer) {
            ServerPlayer mp = (ServerPlayer)player;
            mp.openMenu(ContainerFilter.forStack(hi), buf -> FilterDataComponent.STREAM_CODEC.encode(buf, (Object)((FilterDataComponent)hi.getOrDefault(type, (Object)FilterDataComponent.EMPTY))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen openScreen(Inventory inv, Component label) {
        return new ScreenFilter(this, inv, label);
    }

    public static class FilterData {
        private final FilterDataComponent stack;
        public SimpleInventory inventory = new SimpleInventory(12);
        public UUID id;
        public boolean invert;
        public boolean useod;
        public boolean usemeta;
        public boolean ignorenbt;

        public FilterData(FilterDataComponent stack) {
            this.stack = stack;
            this.id = stack.filterId();
            this.invert = stack.invertList();
            this.useod = stack.useTags();
            this.usemeta = stack.useDamage();
            this.ignorenbt = stack.ignoreComponents();
            List<ItemStack> filter = stack.filter();
            for (int i = 0; i < filter.size(); ++i) {
                this.inventory.setStackInSlot(i, filter.get(i));
            }
        }

        public FilterDataComponent export() {
            return this.stack.toBuilder().filterId(this.id).invertList(this.invert).useTags(this.useod).useDamage(this.usemeta).ignoreComponents(this.ignorenbt).filter(this.inventory.items.stream().map(ItemStack::copy).toList()).build();
        }

        public boolean isThisFilter(ItemStack item) {
            ItemFilterUpgrade up;
            Item item2;
            return !item.isEmpty() && (item2 = item.getItem()) instanceof ItemFilterUpgrade && Objects.equals(this.id, (up = (ItemFilterUpgrade)item2).get(item).filterId());
        }
    }
}

