/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.zeith.hammerlib.client.screen.ScreenWTFMojang;
import org.zeith.hammerlib.client.utils.FXUtils;
import org.zeith.hammerlib.client.utils.RenderUtils;
import org.zeith.hammerlib.util.colors.ColorHelper;
import org.zeith.squarry.SQCommonProxy;
import org.zeith.squarry.SQConfig;
import org.zeith.squarry.SimpleQuarry;
import org.zeith.squarry.api.energy.UniversalConverter;
import org.zeith.squarry.blocks.entity.TilePoweredQuarry;
import org.zeith.squarry.inventory.ContainerPoweredQuarry;
import org.zeith.squarry.mixins.GuiGraphicsAccessor;

public class ScreenPoweredQuarry
extends ScreenWTFMojang<ContainerPoweredQuarry> {
    public static final ResourceLocation POWERED_QUARRY_TEXTURE = SimpleQuarry.id("textures/gui/powered_quarry.png");
    public TilePoweredQuarry tile;
    private static final DecimalFormat df = new DecimalFormat("#0");

    public ScreenPoweredQuarry(ContainerPoweredQuarry container, Inventory inv, Component label) {
        super((AbstractContainerMenu)container, inv, label);
        this.tile = container.tile;
        this.setSize(176, 166);
    }

    protected void renderBackground(GuiGraphics gfx, float partialTime, int mouseX, int mouseY) {
        gfx.blit(POWERED_QUARRY_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        FXUtils.bindTexture((ResourceLocation)POWERED_QUARRY_TEXTURE);
        RenderUtils.drawTexturedModalRect((GuiGraphics)gfx, (float)((float)this.leftPos + 26.5f), (float)(this.topPos + 34), (float)this.imageWidth, (float)14.0f, (float)13.0f, (float)13.0f);
        if (this.tile.totalBurnTicks.getInt() != 0) {
            float fire = 1.0f + (float)this.tile.burnTicks.getInt() / (float)this.tile.totalBurnTicks.getInt() * 13.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.drawTexturedModalRect((GuiGraphics)gfx, (float)(this.leftPos + 25), (float)((float)(this.topPos + 47) - fire), (float)this.imageWidth, (float)(14.0f - fire), (float)14.0f, (float)fire);
        }
        float power = (float)(this.tile.storage.getStoredQF(null) / this.tile.storage.getQFCapacity(null) * 64.0);
        int finalCol = ColorHelper.interpolate((int)-8375296, (int)-103936, (float)(power / 64.0f));
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.fillGradient(gfx, this.leftPos + 7, (float)(this.topPos + 72) - power, 11.0f, power, 0.0f, finalCol, -8375296);
    }

    protected boolean renderForeground(GuiGraphics gfx, int mx, int my) {
        if (mx - this.leftPos >= 6 && my - this.topPos >= 7 && mx - this.leftPos <= 19 && my - this.topPos <= 73) {
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.drawColoredModalRect((GuiGraphics)gfx, (float)7.0f, (float)8.0f, (float)11.0f, (float)64.0f, (int)-2130706433);
            ItemStack mouse = ((ContainerPoweredQuarry)this.menu).getCarried();
            if (mouse.isEmpty()) {
                gfx.renderTooltip(this.font, (Component)Component.literal((String)(df.format(Math.floor(this.tile.storage.getStoredQF(null) / (UniversalConverter.FT_QF(SQCommonProxy.COAL.getBurnTime(null)) / SQConfig.getBlocksPerCoal()))) + " " + I18n.get((String)"info.squarry.blockstobreak", (Object[])new Object[0]))), 16, 48);
            }
        }
        return true;
    }

    public void fillGradient(GuiGraphics gfx, float x1, float y1, float width, float height, float z, int rgb1, int rgb2) {
        this.fillGradient(gfx, RenderType.gui(), x1, y1, x1 + width, y1 + height, z, rgb1, rgb2);
    }

    public void fillGradient(GuiGraphics gfx, RenderType type, float x1, float y1, float x2, float y2, float z, int rgb1, int rgb2) {
        VertexConsumer vertexconsumer = gfx.bufferSource().getBuffer(type);
        this.fillGradient(gfx, vertexconsumer, x1, y1, x2, y2, z, rgb1, rgb2);
        ((GuiGraphicsAccessor)gfx).callFlushIfUnmanaged();
    }

    private void fillGradient(GuiGraphics gfx, VertexConsumer b, float x1, float y1, float x2, float y2, float z, int rgb1, int rgb2) {
        float f = (float)FastColor.ARGB32.alpha((int)rgb1) / 255.0f;
        float f1 = (float)FastColor.ARGB32.red((int)rgb1) / 255.0f;
        float f2 = (float)FastColor.ARGB32.green((int)rgb1) / 255.0f;
        float f3 = (float)FastColor.ARGB32.blue((int)rgb1) / 255.0f;
        float f4 = (float)FastColor.ARGB32.alpha((int)rgb2) / 255.0f;
        float f5 = (float)FastColor.ARGB32.red((int)rgb2) / 255.0f;
        float f6 = (float)FastColor.ARGB32.green((int)rgb2) / 255.0f;
        float f7 = (float)FastColor.ARGB32.blue((int)rgb2) / 255.0f;
        Matrix4f matrix4f = gfx.pose().last().pose();
        b.addVertex(matrix4f, x1, y1, z).setColor(f1, f2, f3, f);
        b.addVertex(matrix4f, x1, y2, z).setColor(f5, f6, f7, f4);
        b.addVertex(matrix4f, x2, y2, z).setColor(f5, f6, f7, f4);
        b.addVertex(matrix4f, x2, y1, z).setColor(f1, f2, f3, f);
    }
}

