/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.client;

import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.zeith.hammerlib.api.proxy.IClientProxy;
import org.zeith.squarry.SQCommonProxy;
import org.zeith.squarry.SQConfig;
import org.zeith.squarry.api.energy.UniversalConverter;
import org.zeith.squarry.api.particle.ClientQuarryVortex;
import org.zeith.squarry.api.particle.ParticleVortex;
import org.zeith.squarry.blocks.entity.TileFuelQuarry;
import org.zeith.squarry.client.screen.ScreenFilter;
import org.zeith.squarry.inventory.ContainerFilter;
import org.zeith.squarry.inventory.ContainerFuelQuarry;
import org.zeith.squarry.inventory.ContainerPoweredQuarry;
import org.zeith.squarry.items.ItemUpgrade;

public class SQClientProxy
extends SQCommonProxy
implements IClientProxy {
    @Override
    public void setup(IEventBus modBus) {
        super.setup(modBus);
        modBus.addListener(this::clientSetup);
        NeoForge.EVENT_BUS.addListener(this::tooltip);
    }

    private void clientSetup(RegisterMenuScreensEvent e) {
        e.register(ContainerFilter.FILTER, ScreenFilter::new);
    }

    @Override
    public ParticleVortex createQuarryVortex(TileFuelQuarry quarry) {
        return new ClientQuarryVortex(quarry);
    }

    private void tooltip(ItemTooltipEvent e) {
        Item item;
        Player p = e.getEntity();
        if (p == null) {
            return;
        }
        ItemStack it = e.getItemStack();
        if (!it.isEmpty() && (item = it.getItem()) instanceof ItemUpgrade) {
            ItemUpgrade up = (ItemUpgrade)item;
            e.getToolTip().add(Component.literal((String)I18n.get((String)"info.squarry.fuel_use_boost", (Object[])new Object[]{Float.valueOf((float)Math.round(up.quarryUseMultiplierClient * 1000.0f) / 1000.0f)})).withStyle(ChatFormatting.DARK_PURPLE));
        }
        if (p.containerMenu instanceof ContainerFuelQuarry || p.containerMenu instanceof ContainerPoweredQuarry) {
            int burnTime;
            AbstractContainerMenu m;
            TileFuelQuarry quarry = null;
            AbstractContainerMenu abstractContainerMenu = p.containerMenu;
            if (abstractContainerMenu instanceof ContainerFuelQuarry) {
                m = (ContainerFuelQuarry)abstractContainerMenu;
                quarry = m.tile;
            }
            if ((abstractContainerMenu = p.containerMenu) instanceof ContainerPoweredQuarry) {
                m = (ContainerPoweredQuarry)abstractContainerMenu;
                quarry = ((ContainerPoweredQuarry)m).tile;
            }
            if ((burnTime = e.getItemStack().getBurnTime(null)) > 0) {
                float mod = quarry != null ? (float)quarry.getUsageMult() : 1.0f;
                e.getToolTip().add(Component.translatable((String)"info.squarry.blocks_broken").withStyle(ChatFormatting.DARK_GRAY).append(": " + (int)(UniversalConverter.FT_QF((float)burnTime / mod) / (UniversalConverter.FT_QF(COAL.getBurnTime(null)) / SQConfig.getBlocksPerCoal()))));
                e.getToolTip().add(Component.translatable((String)"info.squarry.qfuel_use_boost").withStyle(ChatFormatting.DARK_GRAY).append(" " + (int)(mod * 100.0f) + "%"));
            } else {
                e.getToolTip().add(Component.translatable((String)"info.squarry.not_fuel").withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

