/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.blocks.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.squarry.SQConfig;
import org.zeith.squarry.blocks.BlockPoweredQuarry;
import org.zeith.squarry.blocks.entity.TileFuelQuarry;
import org.zeith.squarry.inventory.ContainerPoweredQuarry;
import org.zeith.squarry.items.ItemUpgrade;

@SimplyRegister
public class TilePoweredQuarry
extends TileFuelQuarry
implements IEnergyStorage {
    @RegistryName(value="powered_quarry")
    public static final BlockEntityType<TilePoweredQuarry> POWERED_QUARRY = BlockAPI.createBlockEntityType(TilePoweredQuarry::new, (Block[])new Block[]{BlockPoweredQuarry.POWERED_QUARRY});
    @NBTSerializable
    public final SimpleInventory invUpgrades = new SimpleInventory(5);
    public CompoundTag additionalTags = new CompoundTag();

    protected TilePoweredQuarry(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tickRate = SQConfig.getPoweredQuarryTickRate();
    }

    @Override
    protected double getQFCapacity() {
        return 256000.0;
    }

    @Override
    public double getUsageMult() {
        double val = super.getUsageMult();
        for (int i = 0; i < 5; ++i) {
            if (this.getUpgrade(i) == null) continue;
            val *= (double)this.getUpgrade((int)i).quarryUseMultiplierServer;
        }
        return val;
    }

    public ItemStack getUpgradeStack(int index) {
        return this.invUpgrades.getStackInSlot(index % 5);
    }

    public ItemUpgrade getUpgrade(int index) {
        Item item;
        ItemStack stack = this.getUpgradeStack(index);
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof ItemUpgrade) {
            ItemUpgrade u = (ItemUpgrade)item;
            return u;
        }
        return null;
    }

    public ItemUpgrade[] getUpgrades() {
        ItemUpgrade[] upgrades = new ItemUpgrade[5];
        for (int i = 0; i < 5; ++i) {
            upgrades[i] = this.getUpgrade(i);
        }
        return upgrades;
    }

    @Override
    public void update() {
        IEnergyStorage pc;
        if (!SQConfig.isPoweredQuarry()) {
            return;
        }
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (!stack.isEmpty() && (pc = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
            int canExtract = pc.extractEnergy(pc.getEnergyStored(), true);
            canExtract = Math.min(this.receiveEnergy(canExtract, true), canExtract);
            pc.extractEnergy(canExtract, false);
            this.receiveEnergy(canExtract, false);
        }
        for (int i = 0; i < this.invUpgrades.getContainerSize(); ++i) {
            ItemUpgrade up = this.getUpgrade(i);
            if (up != null && !up.canStay(this, i)) {
                ItemStack s = this.invUpgrades.getStackInSlot(i).copy();
                this.invUpgrades.setItem(i, ItemStack.EMPTY);
                this.queueItems.add(s);
                continue;
            }
            if (up == null) continue;
            up.tick(this, i);
        }
        super.update();
        this.tickRate = SQConfig.getPoweredQuarryTickRate();
    }

    @Override
    public NonNullList<ItemStack> makeDrops(BlockPos pos, BlockState state) {
        NonNullList<ItemStack> drops = super.makeDrops(pos, state);
        for (int i = 0; i < this.invUpgrades.getContainerSize(); ++i) {
            if (this.getUpgrade(i) == null) continue;
            this.getUpgrade(i).handleDrops(this, pos, drops);
        }
        return drops;
    }

    @Override
    public void addQueueItem(ItemStack e) {
        if (e.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.invUpgrades.getContainerSize(); ++i) {
            ItemUpgrade up = this.getUpgrade(i);
            if (up == null) continue;
            try {
                e = up.handlePickup(e, this, i);
                continue;
            }
            catch (Throwable err) {
                err.printStackTrace();
            }
        }
        if (!e.isEmpty()) {
            super.addQueueItem(e);
        }
    }

    @Override
    public AbstractContainerMenu openContainer(Player player, int windowId) {
        if (!SQConfig.isPoweredQuarry()) {
            return null;
        }
        return new ContainerPoweredQuarry(player, windowId, this);
    }

    @Override
    protected Block getQuarryBlock() {
        return BlockPoweredQuarry.POWERED_QUARRY;
    }

    @Override
    public void addToolEnchantments(ItemEnchantments.Mutable enchantmentMap) {
        for (int i = 0; i < this.invUpgrades.getContainerSize(); ++i) {
            ItemUpgrade iu = this.getUpgrade(i);
            if (iu == null) continue;
            iu.addEnchantments(this, enchantmentMap);
        }
    }

    public void readNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readNBT(nbt, provider);
        this.additionalTags = nbt.getCompound("AdditionalTags");
    }

    public CompoundTag writeNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt = super.writeNBT(nbt, provider);
        nbt.put("AdditionalTags", (Tag)this.additionalTags.copy());
        return nbt;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!SQConfig.isPoweredQuarry()) {
            return 0;
        }
        float fec = SQConfig.getFeConversion();
        float hec = SQConfig.getHeConversion();
        if ((float)maxReceive >= fec) {
            return (int)(this.storage.consumeQF(null, (float)maxReceive / fec, simulate) * (double)fec);
        }
        return (int)(this.storage.consumeQF(null, (float)maxReceive / hec, simulate) * (double)hec);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 1000;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public void dropEverything(Level world, BlockPos pos) {
        super.dropEverything(world, pos);
        Containers.dropContents((Level)world, (BlockPos)pos, (Container)this.invUpgrades);
    }
}

