/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.blocks.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.zeith.api.wrench.IWrenchable;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyInt;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.tiles.tooltip.ITooltipConsumer;
import org.zeith.hammerlib.tiles.tooltip.ITooltipTile;
import org.zeith.hammerlib.util.java.DirectStorage;
import org.zeith.squarry.SQCommonProxy;
import org.zeith.squarry.SQConfig;
import org.zeith.squarry.SQConstants;
import org.zeith.squarry.SimpleQuarry;
import org.zeith.squarry.api.ItemInjector;
import org.zeith.squarry.api.ItemStackList;
import org.zeith.squarry.api.energy.QFStorage;
import org.zeith.squarry.api.particle.ParticleVortex;
import org.zeith.squarry.blocks.BlockBaseQuarry;
import org.zeith.squarry.blocks.BlockFuelQuarry;
import org.zeith.squarry.init.TagsSQ;
import org.zeith.squarry.inventory.ContainerFuelQuarry;

@SimplyRegister
public class TileFuelQuarry
extends TileSyncableTickable
implements IContainerTile,
IWrenchable,
ITooltipTile {
    @RegistryName(value="fuel_quarry")
    public static final BlockEntityType<TileFuelQuarry> FUEL_QUARRY = BlockAPI.createBlockEntityType(TileFuelQuarry::new, (Block[])new Block[]{BlockFuelQuarry.FUEL_QUARRY});
    public static final Map<ResourceKey<Level>, Map<ChunkPos, BlockPos>> QUARRY_MAP = new HashMap<ResourceKey<Level>, Map<ChunkPos, BlockPos>>();
    private static final Function<ResourceKey<Level>, Map<ChunkPos, BlockPos>> QUARRY_MAP_COMPUTE = world -> new HashMap();
    @NBTSerializable
    public final SimpleInventory inventory = new SimpleInventory(1);
    public int tickRate = SQConfig.getFuelQuarryTickRate();
    @NBTSerializable
    public int _burnTicks;
    @NBTSerializable
    public int _totalBurnTicks;
    @NBTSerializable(value="y")
    public int _y = Integer.MIN_VALUE;
    @NBTSerializable
    public final QFStorage storage = new QFStorage(this.getQFCapacity());
    @NBTSerializable
    public final ItemStackList queueItems = ItemStackList.createList();
    public AABB boundingBox;
    @NBTSerializable
    private ChunkPos chunkPos;
    public ParticleVortex vortex;
    public final PropertyInt burnTicks = new PropertyInt(DirectStorage.create($ -> {
        this._burnTicks = $;
    }, () -> this._burnTicks));
    public final PropertyInt totalBurnTicks = new PropertyInt(DirectStorage.create($ -> {
        this._totalBurnTicks = $;
    }, () -> this._totalBurnTicks));
    public final PropertyInt yLevel = new PropertyInt(DirectStorage.create($ -> {
        this._y = $;
    }, () -> this._y));

    protected double getQFCapacity() {
        return 8000.0;
    }

    protected TileFuelQuarry(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.dispatcher.registerProperty("burn_ticks", (IProperty)this.burnTicks);
        this.dispatcher.registerProperty("total_burn_ticks", (IProperty)this.totalBurnTicks);
        this.dispatcher.registerProperty("y", (IProperty)this.yLevel);
    }

    public void validateQuarry() {
        Map<ChunkPos, BlockPos> map = QUARRY_MAP.computeIfAbsent((ResourceKey<Level>)this.level.dimension(), QUARRY_MAP_COMPUTE);
        BlockPos cpos = map.get(this.chunkPos);
        if (cpos != null && cpos.asLong() != this.worldPosition.asLong() && this.level.getBlockEntity(cpos) instanceof TileFuelQuarry) {
            this.level.destroyBlock(this.worldPosition, true);
            this.level.explode(null, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), 3.0f, Level.ExplosionInteraction.NONE);
            return;
        }
        map.put(this.chunkPos, this.worldPosition);
    }

    protected Block getQuarryBlock() {
        return BlockFuelQuarry.FUEL_QUARRY;
    }

    public void update() {
        double qf;
        int bt;
        ItemStack stack;
        BlockState state0;
        LevelChunk c = this.level.getChunkAt(this.worldPosition);
        ChunkPos pcp = this.chunkPos;
        this.chunkPos = c.getPos();
        int chunkX = this.chunkPos.x;
        int chunkZ = this.chunkPos.z;
        if (pcp != null && (pcp.x != chunkX || pcp.z != chunkZ)) {
            SimpleQuarry.LOG.info("Quarry moved from chunk {}, {} -> {}, {} (currently at {}). Reset Y level.", (Object)pcp.x, (Object)pcp.z, (Object)chunkX, (Object)chunkZ, (Object)this.worldPosition);
            this.yLevel.setInt(Integer.MIN_VALUE);
        }
        if (this.level.isClientSide) {
            int yMax = this.computeTopmostY();
            if (this.boundingBox == null || this.boundingBox.minY != (double)this._y || this.boundingBox.maxY != (double)yMax + 0.5) {
                this.boundingBox = new AABB((double)(chunkX * 16), (double)this._y, (double)(chunkZ * 16), (double)(chunkX * 16 + 16), (double)yMax + 0.5, (double)(chunkZ * 16 + 16));
            }
            if (SQConfig.isParticleVortex()) {
                if (this.vortex == null) {
                    this.vortex = SimpleQuarry.PROXY.createQuarryVortex(this);
                }
                this.vortex.update();
            }
            return;
        }
        if (this.queueItems.size() >= 2) {
            this.tryEject();
            this.tickRate = SQConfig.getFuelQuarryTickRate();
            return;
        }
        if (this.storage.storedQF > 0.0 && this._y == Integer.MIN_VALUE) {
            this.yLevel.setInt(this.computeTopmostY());
            this.boundingBox = new AABB((double)(chunkX * 16), (double)this._y, (double)(chunkZ * 16), (double)(chunkX * 16 + 16), (double)(this._y + 1), (double)(chunkZ * 16 + 16));
            this.setEnabledState(true);
        }
        if (this.storage.storedQF > 0.0) {
            this.validateQuarry();
        }
        if ((state0 = this.level.getBlockState(this.worldPosition)).getBlock() != this.getQuarryBlock()) {
            this.tickRate = SQConfig.getFuelQuarryTickRate();
            return;
        }
        if (this._y > DimensionType.MIN_Y && this._y <= this.level.getMinBuildHeight()) {
            this.setEnabledState(false);
        }
        double QFPerBlock = SQConstants.FT.convertTo((double)SQCommonProxy.COAL.getBurnTime(null), SQConstants.QF) / SQConfig.getBlocksPerCoal();
        QFPerBlock *= this.getUsageMult();
        if (((Boolean)state0.getValue((Property)BlockStateProperties.ENABLED)).booleanValue() && !this.level.isClientSide && this.atTickRate(20) && this._burnTicks < 1 && !(stack = this.inventory.getStackInSlot(0)).isEmpty() && (bt = stack.getBurnTime(null)) > 0 && this.storage.consumeQF(null, SQConstants.FT.convertTo(1.0, SQConstants.QF), true) == SQConstants.FT.convertTo(1.0, SQConstants.QF)) {
            this.burnTicks.setInt(this.burnTicks.getInt() + bt);
            this.totalBurnTicks.setInt(this.burnTicks.getInt());
            stack.shrink(1);
            this.sync();
        }
        if (this._burnTicks > 0) {
            this.burnTicks.setInt(this._burnTicks - 1);
            double ftqf = SQConstants.FT.convertTo(1.0, SQConstants.QF);
            double qf2 = this.storage.consumeQF(null, ftqf, true);
            if (qf2 == ftqf) {
                this.storage.consumeQF(null, qf2, false);
            }
            this.sync();
        }
        if (Double.isNaN(qf = this.storage.getStoredQF(null)) || Double.isInfinite(qf)) {
            this.storage.storedQF = 0.0;
        }
        if (this._y > this.level.getMinBuildHeight() && this.atTickRate(this.tickRate) && this.storage.getStoredQF(null) >= QFPerBlock) {
            if (this.level.getBlockState(new BlockPos(this.worldPosition.getX(), this._y, this.worldPosition.getZ())).is(TagsSQ.Blocks.QUARRY_PIPE)) {
                this.yLevel.setInt(this._y - 1);
            } else {
                boolean hasBrokenBlock = false;
                for (BlockPos pos : BlockPos.betweenClosed((int)(chunkX * 16), (int)this._y, (int)(chunkZ * 16), (int)(chunkX * 16 + 15), (int)this._y, (int)(chunkZ * 16 + 15))) {
                    BlockState state = this.level.getBlockState(pos);
                    if (this.level.isEmptyBlock(pos) || !this.canBreak(state, pos)) continue;
                    this.captureItems((List<ItemStack>)this.makeDrops(pos, state));
                    hasBrokenBlock = true;
                    this.breakBlock(pos, state);
                    this.storage.produceQF(null, QFPerBlock, false);
                    this.sync();
                    break;
                }
                if (!hasBrokenBlock) {
                    this.yLevel.setInt(this._y - 1);
                }
            }
        }
        if (this.isMining(state0)) {
            this.captureEntityItems(this.level.getEntitiesOfClass(ItemEntity.class, new AABB((double)(chunkX * 16), (double)this._y, (double)(chunkZ * 16), (double)(chunkX * 16 + 16), (double)this.worldPosition.getY(), (double)(chunkZ * 16 + 16))));
        }
        this.tryEject();
        this.tickRate = SQConfig.getFuelQuarryTickRate();
    }

    public int computeTopmostY() {
        BlockPos pos = this.worldPosition.immutable().below();
        if (this.level == null) {
            return pos.getY();
        }
        while (this.level.getBlockState(pos).is(TagsSQ.Blocks.QUARRY_PIPE)) {
            pos = pos.below();
        }
        return pos.getY();
    }

    public boolean isDone() {
        BlockState state0 = this.level.getBlockState(this.worldPosition);
        if (!this.level.isClientSide && state0.getBlock() == this.getQuarryBlock()) {
            return (Boolean)state0.getValue((Property)BlockStateProperties.ENABLED) == false;
        }
        return false;
    }

    public double getUsageMult() {
        return 1.0;
    }

    public void addToolEnchantments(ItemEnchantments.Mutable enchantmentMap) {
    }

    public NonNullList<ItemStack> makeDrops(BlockPos pos, BlockState state) {
        NonNullList drops = NonNullList.create();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            ItemStack tool = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
            ItemEnchantments.Mutable enchMap = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            this.addToolEnchantments(enchMap);
            EnchantmentHelper.setEnchantments((ItemStack)tool, (ItemEnchantments)enchMap.toImmutable());
            LootParams.Builder bl = new LootParams.Builder(sl).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.worldPosition)).withParameter(LootContextParams.TOOL, (Object)tool);
            BlockEntity be = this.level.getBlockEntity(pos);
            if (be != null) {
                bl = bl.withParameter(LootContextParams.BLOCK_ENTITY, (Object)be);
            }
            drops.addAll((Collection)state.getDrops(bl));
        }
        return drops;
    }

    public boolean isMining(BlockState state) {
        return state.getBlock() == this.getQuarryBlock() && (Boolean)state.getValue((Property)BlockStateProperties.ENABLED) != false && this._y > this.level.getMinBuildHeight() && this.storage.storedQF > 0.0;
    }

    public void breakBlock(BlockPos pos, BlockState state) {
        this.level.removeBlock(pos, false);
        FluidState fluidstate = this.level.getFluidState(pos);
        this.level.levelEvent(2001, pos, Block.getId((BlockState)state));
        boolean flag = this.level.setBlock(pos, fluidstate.createLegacyBlock(), 3, 512);
        if (flag) {
            this.level.gameEvent(null, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
    }

    public boolean canBreak(BlockState state, BlockPos pos) {
        if (state.getBlock() instanceof LiquidBlock) {
            return false;
        }
        if (state.getDestroySpeed((BlockGetter)this.level, pos) < 0.0f) {
            return false;
        }
        return !state.is(TagsSQ.Blocks.QUARRY_BLACKLIST);
    }

    public void dropStack(ItemStack stack) {
        RandomSource rand = this.level.getRandom();
        if (!stack.isEmpty() && !this.level.isClientSide) {
            ItemEntity ei = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ() + 0.5, stack.copy());
            ei.setDeltaMovement((rand.nextDouble() - rand.nextDouble()) * 0.045, 1.0 + rand.nextDouble() * 0.5, (rand.nextDouble() - rand.nextDouble()) * 0.045);
            this.level.addFreshEntity((Entity)ei);
        }
    }

    public void tryEject() {
        while (!this.queueItems.isEmpty()) {
            Direction face;
            if (((ItemStack)this.queueItems.get(0)).isEmpty()) {
                this.queueItems.remove(0);
                continue;
            }
            ItemStack stack = (ItemStack)this.queueItems.remove(0);
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            for (int i = 0; i < n && !(stack = ItemInjector.inject(stack, this.level, this.worldPosition.relative(face = directionArray[i]), face.getOpposite())).isEmpty(); ++i) {
            }
            if (stack.isEmpty()) continue;
            this.dropStack(stack);
        }
    }

    public void addQueueItem(ItemStack e) {
        this.queueItems.add(e);
    }

    public void captureItems(List<ItemStack> items) {
        while (!items.isEmpty()) {
            this.addQueueItem(items.remove(0));
        }
    }

    public void captureEntityItems(List<ItemEntity> items) {
        for (int j = 0; j < Math.min(items.size(), 1); ++j) {
            ItemEntity item = items.get(j);
            if (item.getItem().getCount() <= 0) continue;
            this.addQueueItem(item.getItem().copy());
            item.setItem(ItemStack.EMPTY);
            item.kill();
        }
    }

    public void setEnabledState(boolean enabled) {
        BlockState s = this.level.getBlockState(this.worldPosition);
        if (s.getBlock() instanceof BlockBaseQuarry && !Objects.equals(s.getValue((Property)BlockStateProperties.ENABLED), enabled)) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)s.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(enabled)));
            this.level.setBlockEntity((BlockEntity)this);
            this.sync();
        }
    }

    public boolean onWrenchUsed(UseOnContext context) {
        Direction facing;
        Direction origin;
        BlockState state;
        Direction d = context.getClickedFace();
        if (context.getPlayer().isShiftKeyDown()) {
            d = d.getOpposite();
        }
        if ((state = this.level.getBlockState(this.worldPosition)).getBlock() == BlockFuelQuarry.FUEL_QUARRY && (origin = (facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))) != (facing = d == Direction.UP ? facing.getClockWise() : (d == Direction.DOWN ? facing.getCounterClockWise() : d))) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing));
        }
        return true;
    }

    public AbstractContainerMenu openContainer(Player player, int windowId) {
        return new ContainerFuelQuarry(player, windowId, this);
    }

    @Nullable
    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    public void addTooltip(ITooltipConsumer consumer, Player player) {
        if (Integer.MIN_VALUE != this._y) {
            consumer.addLine((Component)Component.literal((String)"Y: ").append(Integer.toString(this._y)));
        }
    }

    public void dropEverything(Level world, BlockPos pos) {
        Containers.dropContents((Level)world, (BlockPos)pos, (NonNullList)this.queueItems);
        Containers.dropContents((Level)world, (BlockPos)pos, (NonNullList)this.inventory.items);
    }

    public RegistryAccess registryAccess() {
        return this.level.registryAccess();
    }
}

