/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.blocks;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.blocks.ICreativeTabBlock;
import org.zeith.hammerlib.api.items.CreativeTab;
import org.zeith.hammerlib.core.adapter.BlockHarvestAdapter;
import org.zeith.hammerlib.core.adapter.TagAdapter;
import org.zeith.squarry.SimpleQuarry;
import org.zeith.squarry.blocks.entity.TileFuelQuarry;
import org.zeith.squarry.init.TagsSQ;

@SimplyRegister
public class BlockQuarryPipe
extends Block
implements ICreativeTabBlock {
    protected static final VoxelShape SHAPE = BlockQuarryPipe.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    @RegistryName(value="quarry_pipe")
    public static final BlockQuarryPipe QUARRY_PIPE = new BlockQuarryPipe(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).strength(2.0f, 8.0f));

    public BlockQuarryPipe(BlockBehaviour.Properties props) {
        super(props);
        TagAdapter.bind(TagsSQ.Blocks.QUARRY_PIPE, (Object[])new Block[]{this});
        BlockHarvestAdapter.bindTool((BlockHarvestAdapter.MineableType)BlockHarvestAdapter.MineableType.PICKAXE, (Tiers)Tiers.IRON, (Block[])new Block[]{this});
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.translatable((String)"info.squarry.quarry_pipe").withStyle(ChatFormatting.GRAY));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.UP, BlockStateProperties.DOWN});
    }

    public BlockState tfState(BlockState base, BlockGetter level, BlockPos pos) {
        BlockState above = level.getBlockState(pos.above());
        BlockState below = level.getBlockState(pos.below());
        return (BlockState)((BlockState)base.setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(above.is((Block)this) || level.getBlockEntity(pos.above()) instanceof TileFuelQuarry))).setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(below.is((Block)this)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.tfState(super.getStateForPlacement(ctx), (BlockGetter)ctx.getLevel(), ctx.getClickedPos());
    }

    public BlockState updateShape(BlockState state, Direction p_60542_, BlockState p_60543_, LevelAccessor level, BlockPos pos, BlockPos p_60546_) {
        return this.tfState(state, (BlockGetter)level, pos);
    }

    public List<ItemStack> getDrops(BlockState p_60537_, LootParams.Builder b) {
        return List.of(new ItemStack((ItemLike)this));
    }

    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public CreativeTab getCreativeTab() {
        return SimpleQuarry.ITEM_GROUP;
    }
}

