/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.blocks.ICreativeTabBlock;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.api.forge.ContainerAPI;
import org.zeith.hammerlib.api.items.CreativeTab;
import org.zeith.hammerlib.core.adapter.BlockHarvestAdapter;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.squarry.SimpleQuarry;
import org.zeith.squarry.blocks.entity.TileFuelQuarry;

public abstract class BlockBaseQuarry
extends BaseEntityBlock
implements ICreativeTabBlock {
    protected BlockBaseQuarry(BlockBehaviour.Properties props) {
        super(props);
        BlockHarvestAdapter.bindTool((BlockHarvestAdapter.MineableType)BlockHarvestAdapter.MineableType.PICKAXE, (Tiers)Tiers.IRON, (Block[])new Block[]{this});
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileFuelQuarry) {
            TileFuelQuarry tfq = (TileFuelQuarry)blockEntity;
            int y = pos.getY();
            int minedLevels = y - tfq._y;
            int maxMineLevels = y - level.getMinBuildHeight();
            int v = Math.round((float)minedLevels * 15.0f / (float)maxMineLevels);
            return 15 - Mth.clamp((int)v, (int)0, (int)15);
        }
        return 0;
    }

    public void onRemove(BlockState prevState, Level world, BlockPos pos, BlockState newState, boolean flag64) {
        if (!prevState.is(newState.getBlock())) {
            BlockEntity b = world.getBlockEntity(pos);
            if (b instanceof TileFuelQuarry) {
                TileFuelQuarry tfq = (TileFuelQuarry)b;
                tfq.dropEverything(world, pos);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(prevState, world, pos, newState, flag64);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> def) {
        def.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.ENABLED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        ContainerAPI.openContainerTile((Player)player, (BlockEntity)((TileFuelQuarry)((Object)Cast.cast((Object)level.getBlockEntity(pos), TileFuelQuarry.class))));
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockAPI.ticker((Level)level);
    }

    public List<ItemStack> getDrops(BlockState p_60537_, LootParams.Builder b) {
        return List.of(new ItemStack((ItemLike)this));
    }

    public CreativeTab getCreativeTab() {
        return SimpleQuarry.ITEM_GROUP;
    }
}

