/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.api.particle;

import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.zeith.squarry.api.particle.ParticleVortex;
import org.zeith.squarry.mixins.client.ParticleEngineAccessor;

public class ClientVortex
extends ParticleVortex {
    public ClientVortex(double x, double y, double z, double vortexStrength, double radius, AABB boundingBox) {
        super(x, y, z, vortexStrength, radius, boundingBox);
    }

    @Override
    public void update() {
        AABB bb = this.getBoundingBox();
        ((ParticleEngineAccessor)Minecraft.getInstance().particleEngine).getParticles().values().stream().flatMap(Collection::stream).filter(p -> p.getBoundingBox().intersects(bb)).forEach(this::processParticle);
    }

    protected void processParticle(Particle p) {
        p.friction = 1.0f;
        Vec3 dir = new Vec3(this.x - p.x, this.y - p.y, this.z - p.z).normalize();
        p.xd = Mth.lerp((double)0.12, (double)p.xd, (double)dir.x);
        p.yd = Mth.lerp((double)0.12, (double)p.yd, (double)dir.y);
        p.zd = Mth.lerp((double)0.12, (double)p.zd, (double)dir.z);
        if (Math.random() > 0.4) {
            Vec3 vec3 = new Vec3(p.x - p.xo, p.y - p.yo, p.z - p.zo);
            if (vec3.length() > 0.1) {
                p.age = Math.max(0, p.age - 1);
            }
        }
    }
}

