/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.api.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import org.zeith.squarry.api.particle.ClientVortex;
import org.zeith.squarry.blocks.entity.TileFuelQuarry;

public class ClientQuarryVortex
extends ClientVortex {
    public final TileFuelQuarry quarry;
    AABB below;

    public ClientQuarryVortex(TileFuelQuarry quarry) {
        super((double)quarry.getBlockPos().getX() + 0.5, (double)quarry.getBlockPos().getY() + 0.5, (double)quarry.getBlockPos().getZ() + 0.5, 16.0, 1.0, null);
        this.quarry = quarry;
    }

    @Override
    public void update() {
        BlockPos qp = this.quarry.getBlockPos();
        int qY = this.quarry.computeTopmostY() + 1;
        this.below = new AABB((double)qp.getX(), (double)(qY - 1), (double)qp.getZ(), (double)(qp.getX() + 1), (double)qY, (double)(qp.getZ() + 1)).move(0.0, 1.0, 0.0);
        this.x = (double)qp.getX() + 0.5;
        this.y = qY;
        this.z = (double)qp.getZ() + 0.5;
        super.update();
    }

    @Override
    protected void processParticle(Particle p) {
        super.processParticle(p);
        if (p.getBoundingBox().intersects(this.below)) {
            p.friction = 0.0f;
            double px = p.x;
            double py = p.y;
            double pz = p.z;
            double mx = Mth.clamp((double)(this.x - px), (double)-1.0, (double)1.0) / 4.0;
            double my = Mth.clamp((double)(this.y - py - 0.55), (double)-1.0, (double)1.0) / 32.0;
            double mz = Mth.clamp((double)(this.z - pz), (double)-1.0, (double)1.0) / 4.0;
            p.xd = mx;
            p.yd = my;
            p.zd = mz;
            p.age = Math.min(p.age + 8, p.getLifetime() - 1);
        }
    }

    @Override
    public AABB getBoundingBox() {
        return this.quarry.boundingBox;
    }
}

