/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.api.energy;

import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.zeith.hammerlib.api.io.IAutoNBTSerializable;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.squarry.api.energy.IQFConsumer;
import org.zeith.squarry.api.energy.IQFProducer;

public class QFStorage
implements IQFConsumer,
IQFProducer,
IAutoNBTSerializable {
    @NBTSerializable(value="QFStored")
    public double storedQF = 0.0;
    @NBTSerializable(value="QFCapacity")
    public double capacity;

    public QFStorage(double capacity) {
        this.capacity = capacity;
    }

    public void fixPower() {
        if (Double.isInfinite(this.storedQF) || Double.isNaN(this.storedQF) || this.storedQF <= 0.01) {
            this.storedQF = 0.0;
        }
        this.storedQF = Math.max(0.0, Math.min(this.capacity, this.storedQF));
    }

    public QFStorage(double capacity, double QF) {
        this(capacity);
        this.fixPower();
    }

    @Override
    public boolean canConnectQF(Direction to) {
        return true;
    }

    @Override
    public double getStoredQF(Direction to) {
        this.fixPower();
        return this.storedQF;
    }

    @Override
    public double getQFCapacity(Direction to) {
        return this.capacity;
    }

    @Override
    public double produceQF(Direction to, double howMuch, boolean simulate) {
        this.fixPower();
        double extracted = Math.min(howMuch, this.storedQF);
        if (!simulate) {
            this.storedQF -= extracted;
        }
        return extracted;
    }

    @Override
    public double consumeQF(Direction from, double howMuch, boolean simulate) {
        this.fixPower();
        double accepted = Math.min(this.capacity - this.storedQF, howMuch);
        if (!simulate) {
            this.storedQF += accepted;
        }
        return accepted;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        this.fixPower();
        return super.serializeNBT(provider);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.fixPower();
    }

    public static QFStorage readQFStorage(CompoundTag nbt) {
        return new QFStorage(nbt.getDouble("QFCapacity"), nbt.getDouble("QFStored"));
    }
}

