/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods.farmers_delight_glm;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IOperation;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.GlobalLootModifier;
import com.yanny.ali.plugin.GlobalLootModifierUtils;
import com.yanny.ali.plugin.IForgeLootModifier;
import com.yanny.ali.plugin.common.nodes.ItemStackNode;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.FieldAccessor;
import com.yanny.ali.plugin.mods.farmers_delight_glm.ModifiedNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.LootModifier;

@ClassAccessor(value="vectorwing.farmersdelight.common.loot.modifier.ReplaceItemModifier")
public class ReplaceItemModifier
extends GlobalLootModifier
implements IForgeLootModifier {
    @FieldAccessor
    private Item removedItem;
    @FieldAccessor
    private Item addedItem;
    @FieldAccessor
    private int addedCount;

    public ReplaceItemModifier(LootModifier parent) {
        super(parent);
    }

    @Override
    public Optional<ILootModifier<?>> getLootModifier(IServerUtils utils) {
        List<LootItemCondition> conditionList = Arrays.asList(this.conditions);
        return GlobalLootModifierUtils.getLootModifier(conditionList, c -> {
            Function<IDataNode, List<IDataNode>> factory = src -> {
                if (src instanceof ItemStackNode) {
                    return Collections.singletonList(src);
                }
                ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
                IItemNode node = (IItemNode)((Object)src);
                List<LootItemCondition> allConditions = Stream.concat(c.stream(), node.getConditions().stream()).toList();
                Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance = TooltipUtils.getChance(utils, allConditions, 1.0f);
                Map<Holder<Enchantment>, Map<Integer, RangeValue>> count = TooltipUtils.getCount(utils, Collections.emptyList());
                ITooltipNode tooltip = EntryTooltipUtils.getTooltip(utils, 0, chance, count, Collections.emptyList(), allConditions);
                if (!c.isEmpty()) {
                    nodes.add(new ModifiedNode(utils, (IDataNode)src, new ItemStackNode(utils, this.addedItem.getDefaultInstance(), new RangeValue(this.addedCount), tooltip)));
                } else {
                    nodes.add(new ItemStackNode(utils, this.addedItem.getDefaultInstance(), new RangeValue(this.addedCount), tooltip));
                }
                return nodes;
            };
            return Collections.singletonList(new IOperation.ReplaceOperation(itemStack -> itemStack.getItem().equals(this.removedItem), factory));
        });
    }
}

