/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.snad;

import com.robrit.snad.Snad;
import com.robrit.snad.blocks.BlockRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="snad", bus=EventBusSubscriber.Bus.MOD)
public class SnadData {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new Lang(packOutput));
            generator.addProvider(true, (DataProvider)new BlockStates(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new ItemModels(packOutput, existingFileHelper));
        }
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new Recipes(packOutput, event.getLookupProvider()));
            generator.addProvider(true, (DataProvider)new TagGenerator(packOutput, event.getLookupProvider(), existingFileHelper));
        }
    }

    public static final class Lang
    extends LanguageProvider {
        public Lang(PackOutput output) {
            super(output, "snad", "en_us");
        }

        protected void addTranslations() {
            this.add("block.snad.snad", "Snad");
            this.add("block.snad.red_snad", "Red Snad");
            this.add("block.snad.suol_snad", "Suol Snad");
        }
    }

    public static final class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
            super(output, "snad", exFileHelper);
        }

        protected void registerStatesAndModels() {
            this.simpleBlock((Block)BlockRegistry.SNAD.get());
            this.simpleBlock((Block)BlockRegistry.RED_SNAD.get());
            this.simpleBlock((Block)BlockRegistry.SUOL_SNAD.get());
        }
    }

    public static final class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "snad", existingFileHelper);
        }

        protected void registerModels() {
            this.withExistingParent("snad", this.modLoc("block/snad"));
            this.withExistingParent("red_snad", this.modLoc("block/red_snad"));
            this.withExistingParent("suol_snad", this.modLoc("block/suol_snad"));
        }
    }

    public static final class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
            super(pOutput, pRegistries);
        }

        protected void buildRecipes(RecipeOutput consumer) {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)BlockRegistry.RED_SNAD.get())).requires((ItemLike)Items.RED_SAND).requires((ItemLike)Items.RED_SAND).unlockedBy("has_red_sand", Recipes.has((ItemLike)Items.RED_SAND)).save(consumer);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)BlockRegistry.SNAD.get())).requires((ItemLike)Items.SAND).requires((ItemLike)Items.SAND).unlockedBy("has_sand", Recipes.has((ItemLike)Items.SAND)).save(consumer);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)BlockRegistry.SUOL_SNAD.get())).requires((ItemLike)Items.SOUL_SAND).requires((ItemLike)Items.SOUL_SAND).unlockedBy("has_soul_sand", Recipes.has((ItemLike)Items.SOUL_SAND)).save(consumer);
        }
    }

    public static final class TagGenerator
    extends BlockTagsProvider {
        public TagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "snad", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(Snad.SNAD_BLOCKS).add((Object[])new Block[]{(Block)BlockRegistry.SNAD.get(), (Block)BlockRegistry.RED_SNAD.get(), (Block)BlockRegistry.SUOL_SNAD.get()});
            this.tag(BlockTags.MINEABLE_WITH_SHOVEL).add((Object[])new Block[]{(Block)BlockRegistry.SNAD.get(), (Block)BlockRegistry.RED_SNAD.get(), (Block)BlockRegistry.SUOL_SNAD.get()});
            this.tag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cactus_plantable_on"))).add((Object[])new Block[]{(Block)BlockRegistry.SNAD.get(), (Block)BlockRegistry.RED_SNAD.get()});
            this.tag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"nether_wart_plantable_on"))).add((Object)((Block)BlockRegistry.SUOL_SNAD.get()));
            this.tag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"sugar_cane_plantable_on"))).add((Object[])new Block[]{(Block)BlockRegistry.SNAD.get(), (Block)BlockRegistry.RED_SNAD.get()});
            this.tag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"bamboo_plantable_on"))).add((Object[])new Block[]{(Block)BlockRegistry.SNAD.get(), (Block)BlockRegistry.RED_SNAD.get()});
            this.tag(Snad.SNAD_PLACEABLE_CROPS).add((Object)Blocks.BAMBOO).add((Object)Blocks.BAMBOO_SAPLING).add((Object)Blocks.CACTUS).add((Object)Blocks.SUGAR_CANE);
            this.tag(Snad.SNAD_REQUIRES_WATER).add((Object)Blocks.SUGAR_CANE);
            this.tag(Snad.SUOL_PLACEABLE_CROPS).add((Object)Blocks.NETHER_WART);
        }
    }
}

