/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.util;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.client.event.handlers.ClientTickEventHandler;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import java.util.ArrayList;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class MaterialTextureDataUtil {
    private MaterialTextureDataUtil() {
        throw new IllegalStateException("Can not instantiate an instance of: MaterialTextureDataUtil. This is a utility class");
    }

    public static MaterialTextureData generateRandomTextureDataFrom(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return MaterialTextureData.EMPTY;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        return MaterialTextureDataUtil.generateRandomTextureDataFrom(block);
    }

    @NotNull
    public static MaterialTextureData generateRandomTextureDataFrom(Block block) {
        if (!(block instanceof IMateriallyTexturedBlock)) {
            return MaterialTextureData.EMPTY;
        }
        IMateriallyTexturedBlock materiallyTexturedBlock = (IMateriallyTexturedBlock)block;
        try {
            MaterialTextureData.Builder newData = MaterialTextureData.builder();
            int localOffset = BuiltInRegistries.BLOCK.getId((Object)block);
            int offsetIndex = 0;
            for (IMateriallyTexturedBlockComponent component : materiallyTexturedBlock.getComponents()) {
                ArrayList<Block> candidates = new ArrayList<Block>(StreamSupport.stream(BuiltInRegistries.BLOCK.getTagOrEmpty(component.getValidSkins()).spliterator(), false).map(Holder::value).toList());
                if (candidates.isEmpty()) continue;
                int index = (int)((ClientTickEventHandler.getInstance().getNonePausedTicks() / 20L + (long)(offsetIndex += localOffset)) % (long)candidates.size());
                Block texture = (Block)candidates.get(index);
                newData.setComponent(component.getId(), texture);
            }
            return newData.build();
        }
        catch (Exception e) {
            return MaterialTextureData.EMPTY;
        }
    }
}

