/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.util;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemStackUtils {
    public static ItemStack getMateriallyTexturedItemStackFromPlayer(Player playerEntity) {
        IDoItem offHandDoItem;
        IDoItem mainHandDoItem;
        ItemStack mainHandStack = playerEntity.getMainHandItem();
        ItemStack offHandStack = playerEntity.getOffhandItem();
        Item item = mainHandStack.getItem();
        if (!(item instanceof IDoItem && (mainHandDoItem = (IDoItem)item).renderPreview() || (item = offHandStack.getItem()) instanceof IDoItem && (offHandDoItem = (IDoItem)item).renderPreview())) {
            return ItemStack.EMPTY;
        }
        DefaultedRegistry blockRegistry = BuiltInRegistries.BLOCK;
        DefaultedRegistry itemRegistry = BuiltInRegistries.ITEM;
        ResourceLocation mainHandItemLocation = itemRegistry.getKey((Object)mainHandStack.getItem());
        ResourceLocation offHandItemLocation = itemRegistry.getKey((Object)offHandStack.getItem());
        if (blockRegistry.containsKey(mainHandItemLocation) && blockRegistry.get(mainHandItemLocation) instanceof IMateriallyTexturedBlock) {
            return mainHandStack;
        }
        if (blockRegistry.containsKey(offHandItemLocation) && blockRegistry.get(offHandItemLocation) instanceof IMateriallyTexturedBlock) {
            return offHandStack;
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    public static InteractionHand getHandWithMateriallyTexturedItemStackFromPlayer(Player player) {
        ItemStack materialStack = ItemStackUtils.getMateriallyTexturedItemStackFromPlayer(player);
        if (materialStack == player.getMainHandItem()) {
            return InteractionHand.MAIN_HAND;
        }
        if (materialStack == player.getOffhandItem()) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }
}

