/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.network;

import java.util.Collection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public interface IClientboundDistributor
extends CustomPacketPayload {
    default public void sendToPlayer(Collection<ServerPlayer> players) {
        for (ServerPlayer serverPlayer : players) {
            this.sendToPlayer(serverPlayer);
        }
    }

    default public void sendToPlayer(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    default public void sendToDimension(ServerLevel serverLevel) {
        PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    default public void sendToTargetPoint(ServerLevel level, @Nullable ServerPlayer excluded, double x, double y, double z, double radius) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, (ServerPlayer)excluded, (double)x, (double)y, (double)z, (double)radius, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    default public void sendToAllClients() {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    default public void sendToTrackingEntity(Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    default public void sendToTrackingEntityAndSelf(Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    default public void sendToPlayersTrackingChunk(LevelChunk chunk) {
        Level level = chunk.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level2, (ChunkPos)chunk.getPos(), (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        String crash = "Got client chunk for server network message: " + this.getClass().getName() + " - " + chunk.getClass().getName();
        if (!FMLEnvironment.production) {
            throw new IllegalArgumentException(crash);
        }
        new IllegalArgumentException(crash).printStackTrace();
    }

    default public void sendToPlayersTrackingChunk(ServerLevel serverLevel, ChunkPos chunkPos) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)chunkPos, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

