/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.vanilla;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.AbstractBlockDoor;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.block.types.DoorType;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipeBuilder;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoorBlock
extends AbstractBlockDoor<DoorBlock>
implements IMateriallyTexturedBlock,
ICachedItemGroupBlock,
EntityBlock {
    public static final EnumProperty<DoorType> TYPE = EnumProperty.create((String)"type", DoorType.class);
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(ResourceLocation.withDefaultNamespace((String)"block/oak_planks"), ModTags.DOORS_MATERIALS, Blocks.OAK_PLANKS)).build();
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();

    public DoorBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(3.0f).noOcclusion().isValidSpawn((state, blockGetter, pos, type) -> false));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)DoorType.FULL)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TYPE});
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    @Override
    public void fillItemCategory(@NotNull NonNullList<ItemStack> items) {
        if (!this.fillItemGroupCache.isEmpty()) {
            items.addAll(this.fillItemGroupCache);
            return;
        }
        try {
            for (DoorType doorType : DoorType.values()) {
                ItemStack result = new ItemStack((ItemLike)this);
                BlockUtils.putPropertyIntoBlockStateTag(result, TYPE, doorType);
                this.fillItemGroupCache.add(result);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        items.addAll(this.fillItemGroupCache);
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, Objects.requireNonNull(placer), stack);
        worldIn.getBlockEntity(pos.above()).applyComponentsFromItemStack(stack);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MateriallyTexturedBlockEntity(blockPos, blockState);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack(world.getBlockEntity(pos), (HolderLookup.Provider)world.registryAccess(), new Property[]{TYPE});
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    @Override
    public void buildRecipes(RecipeOutput recipeOutput) {
        for (DoorType value : DoorType.values()) {
            new ArchitectsCutterRecipeBuilder(this, RecipeCategory.REDSTONE).resultProperty(TYPE, value).saveSuffix(recipeOutput, value.getSerializedName());
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getDOExplosionResistance((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getExplosionResistance(x$0, x$1, x$2, x$3)), state, level, pos, explosion);
    }

    public float getDestroyProgress(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.getDODestroyProgress((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getDestroyProgress(x$0, x$1, x$2, x$3)), state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getDOSoundType((x$0, x$1, x$2, x$3) -> super.getSoundType(x$0, x$1, x$2, x$3), state, level, pos, entity);
    }

    @Override
    public IMateriallyTexturedBlockComponent getMainComponent() {
        return COMPONENTS.get(0);
    }
}

