/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DOStairBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape TOP_AABB = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCTET_NNN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    protected static final VoxelShape OCTET_NNP = Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCTET_NPN = Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape OCTET_NPP = Block.box((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape OCTET_PNN = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape OCTET_PNP = Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCTET_PPN = Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape OCTET_PPP = Block.box((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] TOP_SHAPES = DOStairBlock.makeShapes(TOP_AABB, OCTET_NNN, OCTET_PNN, OCTET_NNP, OCTET_PNP);
    protected static final VoxelShape[] BOTTOM_SHAPES = DOStairBlock.makeShapes(BOTTOM_AABB, OCTET_NPN, OCTET_PPN, OCTET_NPP, OCTET_PPP);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Supplier<BlockState> stateSupplier;

    public DOStairBlock(Supplier<BlockState> state, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)Half.BOTTOM)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.stateSupplier = state;
    }

    private static VoxelShape[] makeShapes(VoxelShape p_56934_, VoxelShape p_56935_, VoxelShape p_56936_, VoxelShape p_56937_, VoxelShape p_56938_) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_56945_ -> DOStairBlock.makeStairShape(p_56945_, p_56934_, p_56935_, p_56936_, p_56937_, p_56938_)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape makeStairShape(int p_56865_, VoxelShape p_56866_, VoxelShape p_56867_, VoxelShape p_56868_, VoxelShape p_56869_, VoxelShape p_56870_) {
        VoxelShape voxelshape = p_56866_;
        if ((p_56865_ & 1) != 0) {
            voxelshape = Shapes.or((VoxelShape)p_56866_, (VoxelShape)p_56867_);
        }
        if ((p_56865_ & 2) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)p_56868_);
        }
        if ((p_56865_ & 4) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)p_56869_);
        }
        if ((p_56865_ & 8) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)p_56870_);
        }
        return voxelshape;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_56872_) {
        Direction direction = p_56872_.getClickedFace();
        BlockPos blockpos = p_56872_.getClickedPos();
        FluidState fluidstate = p_56872_.getLevel().getFluidState(blockpos);
        BlockState blockstate = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)p_56872_.getHorizontalDirection())).setValue(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && p_56872_.getClickLocation().y - (double)blockpos.getY() > 0.5) ? Half.BOTTOM : Half.TOP))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        return (BlockState)blockstate.setValue(SHAPE, (Comparable)this.getStairsShape(blockstate, (BlockGetter)p_56872_.getLevel(), blockpos));
    }

    private StairsShape getStairsShape(BlockState p_56977_, BlockGetter p_56978_, BlockPos p_56979_) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)p_56977_.getValue((Property)FACING);
        BlockState blockstate = p_56978_.getBlockState(p_56979_.relative(direction));
        if (this.isStairs(blockstate) && p_56977_.getValue(HALF) == blockstate.getValue(HALF) && (direction1 = (Direction)blockstate.getValue((Property)FACING)).getAxis() != ((Direction)p_56977_.getValue((Property)FACING)).getAxis() && this.canTakeShape(p_56977_, p_56978_, p_56979_, direction1.getOpposite())) {
            if (direction1 == direction.getCounterClockWise()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = p_56978_.getBlockState(p_56979_.relative(direction.getOpposite()));
        if (this.isStairs(blockstate1) && p_56977_.getValue(HALF) == blockstate1.getValue(HALF) && (direction2 = (Direction)blockstate1.getValue((Property)FACING)).getAxis() != ((Direction)p_56977_.getValue((Property)FACING)).getAxis() && this.canTakeShape(p_56977_, p_56978_, p_56979_, direction2)) {
            if (direction2 == direction.getCounterClockWise()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    public boolean isStairs(BlockState p_56981_) {
        return p_56981_.getBlock() instanceof DOStairBlock;
    }

    private boolean canTakeShape(BlockState p_56971_, BlockGetter p_56972_, BlockPos p_56973_, Direction p_56974_) {
        BlockState blockstate = p_56972_.getBlockState(p_56973_.relative(p_56974_));
        return !this.isStairs(blockstate) || blockstate.getValue((Property)FACING) != p_56971_.getValue((Property)FACING) || blockstate.getValue(HALF) != p_56971_.getValue(HALF);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_56932_) {
        p_56932_.add(new Property[]{FACING, HALF, SHAPE, WATERLOGGED});
    }

    public boolean isPathfindable(BlockState p_56891_, PathComputationType p_56894_) {
        return false;
    }

    public BlockState updateShape(BlockState p_56925_, Direction p_56926_, BlockState p_56927_, LevelAccessor p_56928_, BlockPos p_56929_, BlockPos p_56930_) {
        if (((Boolean)p_56925_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_56928_.scheduleTick(p_56929_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_56928_));
        }
        return p_56926_.getAxis().isHorizontal() ? (BlockState)p_56925_.setValue(SHAPE, (Comparable)this.getStairsShape(p_56925_, (BlockGetter)p_56928_, p_56929_)) : super.updateShape(p_56925_, p_56926_, p_56927_, p_56928_, p_56929_, p_56930_);
    }

    public boolean useShapeForLightOcclusion(BlockState p_56967_) {
        return true;
    }

    public FluidState getFluidState(BlockState p_56969_) {
        return (Boolean)p_56969_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_56969_);
    }

    public BlockState rotate(BlockState p_56922_, Rotation p_56923_) {
        return (BlockState)p_56922_.setValue((Property)FACING, (Comparable)p_56923_.rotate((Direction)p_56922_.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState p_56919_, Mirror p_56920_) {
        Direction direction = (Direction)p_56919_.getValue((Property)FACING);
        StairsShape stairsshape = (StairsShape)p_56919_.getValue(SHAPE);
        switch (p_56920_) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)p_56919_.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)p_56919_.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)p_56919_.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)p_56919_.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return p_56919_.rotate(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)p_56919_.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)p_56919_.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)p_56919_.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)p_56919_.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return p_56919_.rotate(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.mirror(p_56919_, p_56920_);
    }

    public VoxelShape getShape(BlockState p_56956_, BlockGetter p_56957_, BlockPos p_56958_, CollisionContext p_56959_) {
        return (p_56956_.getValue(HALF) == Half.TOP ? TOP_SHAPES : BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(p_56956_)]];
    }

    private int getShapeIndex(BlockState p_56983_) {
        return ((StairsShape)p_56983_.getValue(SHAPE)).ordinal() * 4 + ((Direction)p_56983_.getValue((Property)FACING)).get2DDataValue();
    }
}

