/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.core.data.server;

import com.teamabnormals.blueprint.core.other.tags.BlueprintItemTags;
import com.teamabnormals.incubation.core.Incubation;
import com.teamabnormals.incubation.core.registry.IncubationBlocks;
import com.teamabnormals.incubation.core.registry.IncubationItems;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class IncubationRecipeProvider
extends RecipeProvider {
    public IncubationRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
    }

    public void buildRecipes(RecipeOutput output) {
        IncubationRecipeProvider.nineBlockStorageRecipes(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.EGG, (ItemLike)IncubationBlocks.CHICKEN_EGG_CRATE.get());
        IncubationRecipeProvider.nineBlockStorageRecipes(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.TURTLE_EGG, (ItemLike)IncubationBlocks.TURTLE_EGG_CRATE.get());
        IncubationRecipeProvider.cookingRecipes(output, RecipeCategory.FOOD, (TagKey<Item>)Tags.Items.EGGS, (ItemLike)IncubationItems.FRIED_EGG.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)IncubationItems.SCRAMBLED_EGGS.get())).requires(Tags.Items.EGGS).requires(Tags.Items.EGGS).requires(BlueprintItemTags.MILK).requires((ItemLike)Items.BOWL).unlockedBy(IncubationRecipeProvider.getHasName((ItemLike)Items.BOWL), IncubationRecipeProvider.has((ItemLike)Items.BOWL)).unlockedBy(IncubationRecipeProvider.getHasName((TagKey<Item>)Tags.Items.EGGS), IncubationRecipeProvider.has((TagKey<Item>)Tags.Items.EGGS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IncubationBlocks.HAY_NEST.get())).define(Character.valueOf('#'), (ItemLike)Items.WHEAT).pattern("# #").pattern("###").unlockedBy(IncubationRecipeProvider.getHasName((ItemLike)Items.WHEAT), IncubationRecipeProvider.has((ItemLike)Items.WHEAT)).save(output);
    }

    protected static void nineBlockStorageRecipes(RecipeOutput output, RecipeCategory category, ItemLike item, ItemLike block) {
        IncubationRecipeProvider.nineBlockStorageRecipes(output, category, item, block, IncubationRecipeProvider.getItemName((ItemLike)block), null, IncubationRecipeProvider.getItemName((ItemLike)item), null);
    }

    protected static void nineBlockStorageRecipes(RecipeOutput output, RecipeCategory category, ItemLike item, ItemLike block, String shapedName, @Nullable String shapedGroup, String shapelessName, @Nullable String shapelessGroup) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)item, (int)9).requires(block).group(shapelessGroup).unlockedBy(IncubationRecipeProvider.getHasName(block), IncubationRecipeProvider.has((ItemLike)block)).save(output, Incubation.location(shapelessName));
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)block).define(Character.valueOf('#'), item).pattern("###").pattern("###").pattern("###").group(shapedGroup).unlockedBy(IncubationRecipeProvider.getHasName(item), IncubationRecipeProvider.has((ItemLike)item)).save(output, Incubation.location(shapedName));
    }

    private static void cookingRecipes(RecipeOutput output, RecipeCategory category, TagKey<Item> tag, ItemLike result) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(tag), (RecipeCategory)category, (ItemLike)result, (float)0.35f, (int)200).unlockedBy(IncubationRecipeProvider.getHasName(tag), IncubationRecipeProvider.has(tag)).save(output);
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of(tag), (RecipeCategory)category, (ItemLike)result, (float)0.35f, (int)100).unlockedBy(IncubationRecipeProvider.getHasName(tag), IncubationRecipeProvider.has(tag)).save(output, Incubation.location(IncubationRecipeProvider.getItemName((ItemLike)result.asItem()) + "_from_smoking"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of(tag), (RecipeCategory)category, (ItemLike)result, (float)0.35f, (int)600).unlockedBy(IncubationRecipeProvider.getHasName(tag), IncubationRecipeProvider.has(tag)).save(output, Incubation.location(IncubationRecipeProvider.getItemName((ItemLike)result.asItem()) + "_from_campfire_cooking"));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> tag) {
        return IncubationRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tag).build()});
    }

    protected static String getHasName(ItemLike item) {
        return "has_" + IncubationRecipeProvider.getItemName((ItemLike)item);
    }

    private static String getHasName(TagKey<Item> item) {
        return "has_" + item.location().getPath();
    }
}

