/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.common.entity.ai.goal;

import com.teamabnormals.blueprint.core.api.EggLayer;
import com.teamabnormals.incubation.common.block.BirdNestBlock;
import com.teamabnormals.incubation.common.block.EmptyNestBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LayEggInNestGoal
extends MoveToBlockGoal {
    private final Animal bird;
    private final EggLayer eggLayer;
    private int eggCounter;

    public LayEggInNestGoal(Animal birdIn, double speedIn) {
        super((PathfinderMob)birdIn, speedIn, 16);
        this.bird = birdIn;
        this.eggLayer = (EggLayer)birdIn;
    }

    public boolean canUse() {
        return this.canEggBeLaid() && super.canUse();
    }

    public boolean canContinueToUse() {
        return this.canEggBeLaid() && super.canContinueToUse();
    }

    protected int nextStartTick(PathfinderMob creatureIn) {
        return 40;
    }

    public void start() {
        super.start();
        this.eggCounter = this.adjustedTickDelay(30);
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget() && this.canEggBeLaid()) {
            this.eggCounter = Math.max(0, this.eggCounter - 1);
            if (this.eggCounter <= 0) {
                int i;
                BlockPos blockpos = this.blockPos.above();
                BlockState blockstate = this.bird.level().getBlockState(blockpos);
                Block block = blockstate.getBlock();
                if (block instanceof EmptyNestBlock) {
                    this.bird.level().setBlock(blockpos, ((EmptyNestBlock)block).getNest(this.eggLayer.getEggItem()).defaultBlockState(), 3);
                    this.resetBird();
                } else if (block instanceof BirdNestBlock && ((BirdNestBlock)block).getEgg() == this.eggLayer.getEggItem() && (i = ((Integer)blockstate.getValue((Property)BirdNestBlock.EGGS)).intValue()) < 6) {
                    this.bird.level().setBlock(blockpos, (BlockState)blockstate.setValue((Property)BirdNestBlock.EGGS, (Comparable)Integer.valueOf(i + 1)), 3);
                    this.resetBird();
                }
            }
        }
    }

    private boolean canEggBeLaid() {
        return !this.bird.isBaby() && !this.eggLayer.isBirdJockey() && this.eggLayer.getEggTimer() < 400;
    }

    private void resetBird() {
        RandomSource random = this.bird.getRandom();
        this.bird.playSound(this.eggLayer.getEggLayingSound(), 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
        this.eggLayer.setEggTimer(this.eggLayer.getNextEggTime(random));
    }

    protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.getBlockState(pos.above());
        Block block = blockstate.getBlock();
        return block instanceof EmptyNestBlock || block instanceof BirdNestBlock && ((BirdNestBlock)block).getEgg() == this.eggLayer.getEggItem() && (Integer)blockstate.getValue((Property)BirdNestBlock.EGGS) < 6;
    }
}

