/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.common.block;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.incubation.common.block.EmptyNestBlock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BirdNestBlock
extends Block
implements WorldlyContainerHolder {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    public static final IntegerProperty EGGS = IntegerProperty.create((String)"eggs", (int)1, (int)6);
    private final Supplier<? extends Item> egg;
    private final EmptyNestBlock emptyNest;

    public BirdNestBlock(Supplier<? extends Item> eggIn, EmptyNestBlock emptyNestIn, BlockBehaviour.Properties properties) {
        super(properties);
        this.egg = eggIn;
        this.emptyNest = emptyNestIn;
        this.emptyNest.addNest(this.egg, this);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public BirdNestBlock(ResourceLocation eggIn, EmptyNestBlock emptyNestIn, BlockBehaviour.Properties properties) {
        this(() -> (Item)BuiltInRegistries.ITEM.get(eggIn), emptyNestIn, properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.mayBuild()) {
            if (this.egg.get() != Items.AIR && stack.is(this.egg.get())) {
                int i = (Integer)state.getValue((Property)EGGS);
                if (i < 6) {
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    level.setBlock(pos, (BlockState)state.setValue((Property)EGGS, (Comparable)Integer.valueOf(i + 1)), 3);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                return ItemInteractionResult.CONSUME;
            }
            BirdNestBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.egg.get()));
            BirdNestBlock.removeEgg((Entity)player, state, (LevelAccessor)level, pos);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, handIn, hit);
    }

    public static BlockState removeEgg(@Nullable Entity entity, BlockState state, LevelAccessor level, BlockPos pos) {
        int i = (Integer)state.getValue((Property)EGGS);
        BlockState newState = i > 1 ? (BlockState)state.setValue((Property)EGGS, (Comparable)Integer.valueOf(i - 1)) : ((BirdNestBlock)state.getBlock()).getEmptyNest().defaultBlockState();
        level.setBlock(pos, newState, 3);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)newState));
        return newState;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.getEgg());
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide() && !player.isCreative() && this.getEgg() != null && (Integer)state.getValue((Property)EGGS) > 0) {
            BirdNestBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getEgg(), ((Integer)state.getValue((Property)EGGS)).intValue()));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{EGGS});
    }

    public Item getEgg() {
        return this.egg.get();
    }

    public EmptyNestBlock getEmptyNest() {
        return this.emptyNest;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return (Integer)blockState.getValue((Property)EGGS);
    }

    public WorldlyContainer getContainer(BlockState state, LevelAccessor level, BlockPos pos) {
        return new OutputContainer(state, level, pos, new ItemStack((ItemLike)this.getEgg()));
    }

    public static class OutputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private final ItemStack eggStack;
        private boolean changed;

        public OutputContainer(BlockState state, LevelAccessor level, BlockPos pos, ItemStack stack) {
            super(new ItemStack[]{stack});
            this.state = state;
            this.level = level;
            this.pos = pos;
            this.eggStack = stack;
        }

        public int getMaxStackSize() {
            return 1;
        }

        public int[] getSlotsForFace(Direction side) {
            int[] nArray;
            if (side == Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
            return false;
        }

        public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
            return !this.changed && direction == Direction.DOWN && stack.is(this.eggStack.getItem());
        }

        public void setChanged() {
            BirdNestBlock.removeEgg(null, this.state, this.level, this.pos);
            this.changed = true;
        }
    }
}

