/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.item;

import com.teamremastered.endrem.block.AncientPortalFrame;
import com.teamremastered.endrem.config.ConfigHandler;
import com.teamremastered.endrem.mixin.accessor.EyeOfEnderEntityAccessorMixin;
import com.teamremastered.endrem.registry.CommonBlockRegistry;
import java.util.List;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class EREnderEye
extends Item {
    public static String eyePlaced = "empty";

    public EREnderEye(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext world, List<Component> tooltip, TooltipFlag tooltipContext) {
        String translationKey = String.format("item.%s.%s.description", "endrem", this.getId());
        tooltip.add((Component)Component.translatable((String)translationKey));
    }

    public InteractionResult useOn(UseOnContext itemUse) {
        boolean frameHasEye;
        BlockPos blockpos;
        Level level = itemUse.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = itemUse.getClickedPos());
        if (blockstate.is(CommonBlockRegistry.ANCIENT_PORTAL_FRAME)) {
            frameHasEye = (Boolean)blockstate.getValue((Property)AncientPortalFrame.HAS_EYE);
        } else if (blockstate.is(Blocks.END_PORTAL_FRAME)) {
            frameHasEye = (Boolean)blockstate.getValue((Property)BlockStateProperties.EYE);
        } else {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!frameHasEye) {
            BlockState newBlockState = CommonBlockRegistry.ANCIENT_PORTAL_FRAME.defaultBlockState();
            newBlockState = (BlockState)newBlockState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)blockstate.getValue((Property)HorizontalDirectionalBlock.FACING)));
            newBlockState = (BlockState)newBlockState.setValue((Property)AncientPortalFrame.HAS_EYE, (Comparable)Boolean.TRUE);
            eyePlaced = this.getId();
            if (AncientPortalFrame.isFrameAbsent(level, itemUse, blockpos)) {
                Block.pushEntitiesUp((BlockState)blockstate, (BlockState)newBlockState, (LevelAccessor)level, (BlockPos)blockpos);
                level.setBlock(blockpos, newBlockState, 2);
                level.updateNeighbourForOutputSignal(blockpos, CommonBlockRegistry.ANCIENT_PORTAL_FRAME);
                itemUse.getItemInHand().shrink(1);
                level.levelEvent(1503, blockpos, 0);
                BlockPattern.BlockPatternMatch blockpattern$patternhelper = AncientPortalFrame.getCompletedPortalShape(true).find((LevelReader)level, blockpos);
                if (blockpattern$patternhelper != null) {
                    BlockPos blockpos1 = blockpattern$patternhelper.getFrontTopLeft().offset(-3, 0, -3);
                    for (int i = 0; i < 3; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            level.setBlock(blockpos1.offset(i, 0, j), Blocks.END_PORTAL.defaultBlockState(), 2);
                        }
                    }
                    level.globalLevelEvent(1038, blockpos1.offset(1, 0, 1), 0);
                }
                return InteractionResult.CONSUME;
            }
            itemUse.getPlayer().displayClientMessage((Component)Component.translatable((String)"block.endrem.custom_eye.place"), true);
            return InteractionResult.PASS;
        }
        if (blockstate.is(Blocks.END_PORTAL_FRAME) && ConfigHandler.CAN_REMOVE_EYE) {
            BlockState newBlockState = (BlockState)blockstate.setValue((Property)BlockStateProperties.EYE, (Comparable)Boolean.valueOf(false));
            level.setBlock(blockpos, newBlockState, 2);
            level.addFreshEntity((Entity)new ItemEntity(level, (double)blockpos.getX(), (double)(blockpos.getY() + 1), (double)blockpos.getZ(), new ItemStack((ItemLike)Items.ENDER_EYE)));
            return InteractionResult.SUCCESS;
        }
        itemUse.getPlayer().displayClientMessage((Component)Component.translatable((String)"block.endrem.custom_eye.frame_has_eye"), true);
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level levelIn, Player playerIn, InteractionHand handIn) {
        BlockPos blockpos;
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        BlockHitResult raytraceResult = EREnderEye.getPlayerPOVHitResult((Level)levelIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        boolean lookingAtFrame = false;
        BlockState state = levelIn.getBlockState(raytraceResult.getBlockPos());
        if (state.is(CommonBlockRegistry.ANCIENT_PORTAL_FRAME)) {
            lookingAtFrame = true;
        }
        if (lookingAtFrame) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        playerIn.startUsingItem(handIn);
        if (levelIn instanceof ServerLevel && (blockpos = ((ServerLevel)levelIn).findNearestMapStructure(StructureTags.EYE_OF_ENDER_LOCATED, playerIn.blockPosition(), 100, false)) != null) {
            EyeOfEnder eyeofenderentity = new EyeOfEnder(levelIn, playerIn.getX(), playerIn.getY(0.5), playerIn.getZ());
            eyeofenderentity.setItem(itemstack);
            eyeofenderentity.signalTo(blockpos);
            ((EyeOfEnderEntityAccessorMixin)eyeofenderentity).setSurviveAfterDeath(ConfigHandler.EYE_BREAK_PROBABILITY <= playerIn.getRandom().nextInt(100));
            levelIn.addFreshEntity((Entity)eyeofenderentity);
            if (playerIn instanceof ServerPlayer) {
                CriteriaTriggers.USED_ENDER_EYE.trigger((ServerPlayer)playerIn, blockpos);
            }
            levelIn.playSound(null, playerIn.blockPosition(), SoundEvents.ENDER_EYE_LAUNCH, SoundSource.NEUTRAL, 0.5f, 0.4f / (levelIn.getRandom().nextFloat() * 0.4f + 0.8f));
            levelIn.levelEvent(null, 1003, playerIn.blockPosition(), 0);
            if (!playerIn.isCreative()) {
                itemstack.shrink(1);
            }
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
            playerIn.swing(handIn, true);
            return InteractionResultHolder.success((Object)itemstack);
        }
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        String translationKey = String.format("item.%s.%s.description", "endrem", this.asItem());
        tooltip.add((Component)Component.translatable((String)translationKey));
    }

    public String getId() {
        String[] eyeID = this.toString().split(":");
        return eyeID[1];
    }
}

