/*
 * Decompiled with CFR 0.152.
 */
package einstein.usefulslime.util;

import einstein.usefulslime.platform.Services;
import java.util.IdentityHashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class BounceHandler {
    public static final IdentityHashMap<Entity, BounceHandler> BOUNCING_ENTITIES = new IdentityHashMap();
    public final LivingEntity entity;
    private int timer = 0;
    private boolean wasInAir = false;
    private double bounce;
    private int bounceTick;
    private double lastMoveX;
    private double lastMoveZ;

    public BounceHandler(LivingEntity entity, double bounce) {
        this.entity = entity;
        this.bounce = bounce;
        this.bounceTick = bounce != 0.0 ? entity.tickCount : 0;
        BOUNCING_ENTITIES.put((Entity)entity, this);
    }

    public void onPlayerTick(Player player) {
        if (player == this.entity) {
            if (player.getAbilities().flying || this.entity.isSwimming() || this.entity.isInWaterOrBubble() || this.entity.onClimbable() || this.entity.isSpectator() || this.entity.isFallFlying()) {
                BOUNCING_ENTITIES.remove(this.entity);
                return;
            }
            if (player.tickCount == this.bounceTick) {
                Vec3 playerMovement = player.getDeltaMovement();
                player.setDeltaMovement(playerMovement.x, this.bounce, playerMovement.z);
                this.bounceTick = 0;
            }
            if (!(this.entity.onGround() || this.entity.tickCount == this.bounceTick || this.lastMoveX == this.entity.getDeltaMovement().x && this.lastMoveZ == this.entity.getDeltaMovement().z)) {
                double d = 0.935;
                Vec3 entityMovement = this.entity.getDeltaMovement();
                player.setDeltaMovement(entityMovement.x / d, entityMovement.y, entityMovement.z / d);
                this.entity.hasImpulse = true;
                this.lastMoveX = this.entity.getDeltaMovement().x;
                this.lastMoveZ = this.entity.getDeltaMovement().z;
            }
            if (this.wasInAir && this.entity.onGround()) {
                if (this.timer == 0) {
                    this.timer = this.entity.tickCount;
                } else if (this.entity.tickCount - this.timer > 5) {
                    BOUNCING_ENTITIES.remove(this.entity);
                }
                return;
            }
            this.timer = 0;
            this.wasInAir = true;
        }
    }

    public static void addBounceHandler(LivingEntity entity) {
        BounceHandler.addBounceHandler(entity, 0.0);
    }

    public static void addBounceHandler(LivingEntity entity, double bounce) {
        if (!(entity instanceof Player) || Services.PLATFORM.isFakePlayer(entity)) {
            return;
        }
        BounceHandler handler = BOUNCING_ENTITIES.get(entity);
        if (handler == null) {
            new BounceHandler(entity, bounce);
        } else if (bounce != 0.0) {
            handler.bounce = bounce;
            handler.bounceTick = entity.tickCount;
        }
    }
}

